/*
 * Decompiled with CFR 0.152.
 */
package com.common.sdk.connect;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.common.sdk.PrinterHelper;
import com.common.sdk.connect.BaseConnection;
import com.common.sdk.util.LogUtil;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0016H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/common/sdk/connect/USBConnect;", "Lcom/common/sdk/connect/BaseConnection;", "Ljava/io/Serializable;", "()V", "inEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "isConnect", "", "openDevice", "Landroid/hardware/usb/UsbDeviceConnection;", "outEndpoint", "connectBT", "", "mac", "", "connectUSB", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "connectWifi", "ip", "disConnect", "readData", "", "timeout", "", "writeData", "data", "Common_release"})
public final class USBConnect
extends BaseConnection
implements Serializable {
    @Nullable
    private UsbEndpoint inEndpoint;
    @Nullable
    private UsbEndpoint outEndpoint;
    @Nullable
    private UsbDeviceConnection openDevice;
    private boolean isConnect;

    @Override
    public boolean isConnect() {
        if (this.openDevice == null) {
            return false;
        }
        return this.isConnect;
    }

    @Override
    public int connectBT(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"mac");
        return -1;
    }

    @Override
    public int connectWifi(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"ip");
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int connectUSB(@NotNull UsbDevice var1_1) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"usbDevice");
            try {
                if (PrinterHelper.getmContext() == null) {
                    return -3;
                }
                this.isConnect = false;
                v0 = PrinterHelper.getmContext().getSystemService("usb");
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type android.hardware.usb.UsbManager");
                var2_2 = ((UsbManager)v0).openDevice(var1_1);
                if (var2_2 == null) {
                    return -1;
                }
                this.openDevice = var2_2;
                var1_1 = var1_1.getInterface(0);
                Intrinsics.checkNotNullExpressionValue((Object)var1_1, (String)"getInterface(...)");
                var3_5 = var1_1.getEndpointCount();
                for (var2_3 = 0; var2_3 < var3_5; ++var2_3) {
                    var4_6 = var1_1.getEndpoint(var2_3);
                    if (7 != var1_1.getInterfaceClass() || var4_6.getDirection() != 128) ** break block11
                    this.outEndpoint = var4_6;
                    if (var1_1.getEndpointCount() != 1) ** break block11
                    this.inEndpoint = var4_6;
                }
            }
            catch (Exception v1) {}
            {
                if (7 != var1_1.getInterfaceClass() || var4_6.getDirection() != 0) continue;
                this.inEndpoint = var4_6;
                if (var1_1.getEndpointCount() != 1) continue;
                this.outEndpoint = var4_6;
                continue;
            }
            var2_4 = this.openDevice;
            if (var2_4 == null) break block12;
            var2_4.claimInterface((UsbInterface)var1_1, true);
        }
        this.isConnect = true;
        return 0;
        this.isConnect = false;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeData(@NotNull byte[] byArray) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
        if (this.openDevice == null) {
            return false;
        }
        try {
            int n;
            byte[] byArray2 = new byte[10000];
            for (int i = byArray.length; i > 0; i -= n) {
                n = RangesKt.coerceAtMost((int)i, (int)10000);
                System.arraycopy(byArray, byArray.length - i, byArray2, 0, n);
                object = this.openDevice;
                object = object != null ? Integer.valueOf(object.bulkTransfer(this.inEndpoint, byArray2, n, 0)) : null;
            }
        }
        catch (Exception exception) {}
        {
            if (object != Integer.valueOf(-1)) continue;
            this.isConnect = false;
            return false;
        }
        LogUtil.writeLog("USB writer:", byArray);
        return true;
        this.isConnect = false;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public byte[] readData(long l) {
        int n = 1024;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[]{};
        long l2 = 0L;
        while (l2 < l) {
            block9: {
                long l3;
                block8: {
                    int n2;
                    long l4 = l2;
                    long l5 = l;
                    l2 = 10;
                    try {
                        Object object;
                        Thread.sleep(l5 / l2);
                        l3 = l4 + l5 / l2;
                        UsbDeviceConnection usbDeviceConnection = this.openDevice;
                        if (usbDeviceConnection != null) {
                            object = this.outEndpoint;
                            int n3 = (int)(l / l2);
                            object = usbDeviceConnection.bulkTransfer(object, byArray, n, n3);
                        } else {
                            object = null;
                        }
                        UsbEndpoint usbEndpoint = object;
                        Intrinsics.checkNotNull(usbEndpoint);
                        n2 = usbEndpoint.intValue();
                        if (n2 <= 0) break block8;
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    LogUtil.writeLog("USB read:", byArray2);
                    l2 = l;
                    continue;
                }
                l2 = l3;
                continue;
            }
            this.isConnect = false;
            return byArray2;
        }
        return byArray2;
    }

    @Override
    public boolean disConnect() {
        uSBConnect.isConnect = false;
        USBConnect uSBConnect = uSBConnect.openDevice;
        if (uSBConnect != null) {
            if (uSBConnect != null) {
                uSBConnect.close();
            }
            return true;
        }
        return false;
    }
}

