/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import com.android.volley.Cache;
import com.android.volley.VolleyLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiskBasedCache
implements Cache {
    private final Map<String, CacheHeader> mEntries = new LinkedHashMap<String, CacheHeader>(16, 0.75f, true);
    private long mTotalSize = 0L;
    private final File mRootDirectory;
    private final int mMaxCacheSizeInBytes;
    private static final int DEFAULT_DISK_USAGE_BYTES = 0x500000;
    private static final float HYSTERESIS_FACTOR = 0.9f;
    private static final int CACHE_VERSION = 2;

    public DiskBasedCache(File rootDirectory, int maxCacheSizeInBytes) {
        this.mRootDirectory = rootDirectory;
        this.mMaxCacheSizeInBytes = maxCacheSizeInBytes;
    }

    public DiskBasedCache(File rootDirectory) {
        this(rootDirectory, 0x500000);
    }

    @Override
    public synchronized void clear() {
        File[] files = this.mRootDirectory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        this.mEntries.clear();
        this.mTotalSize = 0L;
        VolleyLog.d("Cache cleared.", new Object[0]);
    }

    @Override
    public synchronized Cache.Entry get(String key) {
        CacheHeader entry = this.mEntries.get(key);
        if (entry == null) {
            return null;
        }
        File file = this.getFileForKey(key);
        FilterInputStream cis = null;
        try {
            cis = new CountingInputStream(new FileInputStream(file));
            CacheHeader.readHeader(cis);
            byte[] data = DiskBasedCache.streamToBytes(cis, (int)(file.length() - (long)((CountingInputStream)cis).bytesRead));
            Cache.Entry entry2 = entry.toCacheEntry(data);
            return entry2;
        }
        catch (IOException e) {
            VolleyLog.d("%s: %s", file.getAbsolutePath(), e.toString());
            this.remove(key);
            return null;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
    }

    @Override
    public synchronized void initialize() {
        if (!this.mRootDirectory.exists()) {
            if (!this.mRootDirectory.mkdirs()) {
                VolleyLog.e("Unable to create cache dir %s", this.mRootDirectory.getAbsolutePath());
            }
            return;
        }
        File[] files = this.mRootDirectory.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                File file = fileArray[n2];
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(file);
                        CacheHeader entry = CacheHeader.readHeader(fis);
                        entry.size = file.length();
                        this.putEntry(entry.key, entry);
                    }
                    catch (IOException e) {
                        if (file != null) {
                            file.delete();
                        }
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    @Override
    public synchronized void invalidate(String key, boolean fullExpire) {
        Cache.Entry entry = this.get(key);
        if (entry != null) {
            entry.softTtl = 0L;
            if (fullExpire) {
                entry.ttl = 0L;
            }
            this.put(key, entry);
        }
    }

    @Override
    public synchronized void put(String key, Cache.Entry entry) {
        this.pruneIfNeeded(entry.data.length);
        File file = this.getFileForKey(key);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            CacheHeader e = new CacheHeader(key, entry);
            e.writeHeader(fos);
            fos.write(entry.data);
            fos.close();
            this.putEntry(key, e);
            return;
        }
        catch (IOException fos) {
            boolean deleted = file.delete();
            if (!deleted) {
                VolleyLog.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public synchronized void remove(String key) {
        boolean deleted = this.getFileForKey(key).delete();
        this.removeEntry(key);
        if (!deleted) {
            VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", key, this.getFilenameForKey(key));
        }
    }

    private String getFilenameForKey(String key) {
        int firstHalfLength = key.length() / 2;
        String localFilename = String.valueOf(key.substring(0, firstHalfLength).hashCode());
        localFilename = String.valueOf(localFilename) + String.valueOf(key.substring(firstHalfLength).hashCode());
        return localFilename;
    }

    public File getFileForKey(String key) {
        return new File(this.mRootDirectory, this.getFilenameForKey(key));
    }

    private void pruneIfNeeded(int neededSpace) {
        if (this.mTotalSize + (long)neededSpace < (long)this.mMaxCacheSizeInBytes) {
            return;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("Pruning old cache entries.", new Object[0]);
        }
        long before = this.mTotalSize;
        int prunedFiles = 0;
        long startTime = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, CacheHeader>> iterator = this.mEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CacheHeader> entry = iterator.next();
            CacheHeader e = entry.getValue();
            boolean deleted = this.getFileForKey(e.key).delete();
            if (deleted) {
                this.mTotalSize -= e.size;
            } else {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", e.key, this.getFilenameForKey(e.key));
            }
            iterator.remove();
            ++prunedFiles;
            if ((float)(this.mTotalSize + (long)neededSpace) < (float)this.mMaxCacheSizeInBytes * 0.9f) break;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("pruned %d files, %d bytes, %d ms", prunedFiles, this.mTotalSize - before, SystemClock.elapsedRealtime() - startTime);
        }
    }

    private void putEntry(String key, CacheHeader entry) {
        if (!this.mEntries.containsKey(key)) {
            this.mTotalSize += entry.size;
        } else {
            CacheHeader oldEntry = this.mEntries.get(key);
            this.mTotalSize += entry.size - oldEntry.size;
        }
        this.mEntries.put(key, entry);
    }

    private void removeEntry(String key) {
        CacheHeader entry = this.mEntries.get(key);
        if (entry != null) {
            this.mTotalSize -= entry.size;
            this.mEntries.remove(key);
        }
    }

    private static byte[] streamToBytes(InputStream in, int length) throws IOException {
        int count;
        byte[] bytes = new byte[length];
        int pos = 0;
        while (pos < length && (count = in.read(bytes, pos, length - pos)) != -1) {
            pos += count;
        }
        if (pos != length) {
            throw new IOException("Expected " + length + " bytes, read " + pos + " bytes");
        }
        return bytes;
    }

    private static class CacheHeader {
        public long size;
        public String key;
        public String etag;
        public long serverDate;
        public long ttl;
        public long softTtl;
        public Map<String, String> responseHeaders;

        private CacheHeader() {
        }

        public CacheHeader(String key, Cache.Entry entry) {
            this.key = key;
            this.size = entry.data.length;
            this.etag = entry.etag;
            this.serverDate = entry.serverDate;
            this.ttl = entry.ttl;
            this.softTtl = entry.softTtl;
            this.responseHeaders = entry.responseHeaders;
        }

        public static CacheHeader readHeader(InputStream is) throws IOException {
            CacheHeader entry = new CacheHeader();
            ObjectInputStream ois = new ObjectInputStream(is);
            byte version = ois.readByte();
            if (version != 2) {
                throw new IOException();
            }
            entry.key = ois.readUTF();
            entry.etag = ois.readUTF();
            if (entry.etag.equals("")) {
                entry.etag = null;
            }
            entry.serverDate = ois.readLong();
            entry.ttl = ois.readLong();
            entry.softTtl = ois.readLong();
            entry.responseHeaders = CacheHeader.readStringStringMap(ois);
            return entry;
        }

        public Cache.Entry toCacheEntry(byte[] data) {
            Cache.Entry e = new Cache.Entry();
            e.data = data;
            e.etag = this.etag;
            e.serverDate = this.serverDate;
            e.ttl = this.ttl;
            e.softTtl = this.softTtl;
            e.responseHeaders = this.responseHeaders;
            return e;
        }

        public boolean writeHeader(OutputStream os) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeByte(2);
                oos.writeUTF(this.key);
                oos.writeUTF(this.etag == null ? "" : this.etag);
                oos.writeLong(this.serverDate);
                oos.writeLong(this.ttl);
                oos.writeLong(this.softTtl);
                CacheHeader.writeStringStringMap(this.responseHeaders, oos);
                oos.flush();
                return true;
            }
            catch (IOException e) {
                VolleyLog.d("%s", e.toString());
                return false;
            }
        }

        private static void writeStringStringMap(Map<String, String> map, ObjectOutputStream oos) throws IOException {
            if (map != null) {
                oos.writeInt(map.size());
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    oos.writeUTF(entry.getKey());
                    oos.writeUTF(entry.getValue());
                }
            } else {
                oos.writeInt(0);
            }
        }

        private static Map<String, String> readStringStringMap(ObjectInputStream ois) throws IOException {
            int size = ois.readInt();
            HashMap<String, String> result = size == 0 ? Collections.emptyMap() : new HashMap<String, String>(size);
            int i = 0;
            while (i < size) {
                String key = ois.readUTF().intern();
                String value = ois.readUTF().intern();
                result.put(key, value);
                ++i;
            }
            return result;
        }
    }

    private static class CountingInputStream
    extends FilterInputStream {
        private int bytesRead = 0;

        private CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                ++this.bytesRead;
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int result = super.read(buffer, offset, count);
            if (result != -1) {
                this.bytesRead += result;
            }
            return result;
        }
    }
}

