/*
 * Decompiled with CFR 0.152.
 */
package com.handmark.pulltorefresh.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.handmark.pulltorefresh.library.LoadingLayoutProxy;
import com.handmark.pulltorefresh.library.OverscrollHelper;
import com.handmark.pulltorefresh.library.PullToRefreshAdapterViewBase;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.R;
import com.handmark.pulltorefresh.library.internal.EmptyViewMethodAccessor;
import com.handmark.pulltorefresh.library.internal.LoadingLayout;

public class PullToRefreshListView
extends PullToRefreshAdapterViewBase<ListView> {
    private LoadingLayout mHeaderLoadingView;
    private LoadingLayout mFooterLoadingView;
    private FrameLayout mLvFooterLoadingFrame;
    private boolean mListViewExtrasEnabled;

    public PullToRefreshListView(Context context) {
        super(context);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PullToRefreshListView(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
    }

    public PullToRefreshListView(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle style) {
        super(context, mode, style);
    }

    @Override
    public final PullToRefreshBase.Orientation getPullToRefreshScrollDirection() {
        return PullToRefreshBase.Orientation.VERTICAL;
    }

    @Override
    protected void onRefreshing(boolean doScroll) {
        int scrollToY;
        int selection;
        LoadingLayout oppositeListViewLoadingView;
        LoadingLayout listViewLoadingView;
        LoadingLayout origLoadingView;
        ListAdapter adapter = ((ListView)this.mRefreshableView).getAdapter();
        if (!this.mListViewExtrasEnabled || !this.getShowViewWhileRefreshing() || null == adapter || adapter.isEmpty()) {
            super.onRefreshing(doScroll);
            return;
        }
        super.onRefreshing(false);
        switch (this.getCurrentMode()) {
            case MANUAL_REFRESH_ONLY: 
            case PULL_FROM_END: {
                origLoadingView = this.getFooterLayout();
                listViewLoadingView = this.mFooterLoadingView;
                oppositeListViewLoadingView = this.mHeaderLoadingView;
                selection = ((ListView)this.mRefreshableView).getCount() - 1;
                scrollToY = this.getScrollY() - this.getFooterSize();
                break;
            }
            default: {
                origLoadingView = this.getHeaderLayout();
                listViewLoadingView = this.mHeaderLoadingView;
                oppositeListViewLoadingView = this.mFooterLoadingView;
                selection = 0;
                scrollToY = this.getScrollY() + this.getHeaderSize();
            }
        }
        origLoadingView.reset();
        origLoadingView.hideAllViews();
        oppositeListViewLoadingView.setVisibility(8);
        listViewLoadingView.setVisibility(0);
        listViewLoadingView.refreshing();
        if (doScroll) {
            this.disableLoadingLayoutVisibilityChanges();
            this.setHeaderScroll(scrollToY);
            ((ListView)this.mRefreshableView).setSelection(selection);
            this.smoothScrollTo(0);
        }
    }

    @Override
    protected void onReset() {
        boolean scrollLvToEdge;
        int scrollToHeight;
        int selection;
        LoadingLayout listViewLoadingLayout;
        LoadingLayout originalLoadingLayout;
        if (!this.mListViewExtrasEnabled) {
            super.onReset();
            return;
        }
        switch (this.getCurrentMode()) {
            case MANUAL_REFRESH_ONLY: 
            case PULL_FROM_END: {
                originalLoadingLayout = this.getFooterLayout();
                listViewLoadingLayout = this.mFooterLoadingView;
                selection = ((ListView)this.mRefreshableView).getCount() - 1;
                scrollToHeight = this.getFooterSize();
                scrollLvToEdge = Math.abs(((ListView)this.mRefreshableView).getLastVisiblePosition() - selection) <= 1;
                break;
            }
            default: {
                originalLoadingLayout = this.getHeaderLayout();
                listViewLoadingLayout = this.mHeaderLoadingView;
                scrollToHeight = -this.getHeaderSize();
                selection = 0;
                boolean bl = scrollLvToEdge = Math.abs(((ListView)this.mRefreshableView).getFirstVisiblePosition() - selection) <= 1;
            }
        }
        if (listViewLoadingLayout.getVisibility() == 0) {
            originalLoadingLayout.showInvisibleViews();
            listViewLoadingLayout.setVisibility(8);
            if (scrollLvToEdge && this.getState() != PullToRefreshBase.State.MANUAL_REFRESHING) {
                ((ListView)this.mRefreshableView).setSelection(selection);
                this.setHeaderScroll(scrollToHeight);
            }
        }
        super.onReset();
    }

    @Override
    protected LoadingLayoutProxy createLoadingLayoutProxy(boolean includeStart, boolean includeEnd) {
        LoadingLayoutProxy proxy = super.createLoadingLayoutProxy(includeStart, includeEnd);
        if (this.mListViewExtrasEnabled) {
            PullToRefreshBase.Mode mode = this.getMode();
            if (includeStart && mode.showHeaderLoadingLayout()) {
                proxy.addLayout(this.mHeaderLoadingView);
            }
            if (includeEnd && mode.showFooterLoadingLayout()) {
                proxy.addLayout(this.mFooterLoadingView);
            }
        }
        return proxy;
    }

    protected ListView createListView(Context context, AttributeSet attrs) {
        InternalListView lv = Build.VERSION.SDK_INT >= 9 ? new InternalListViewSDK9(context, attrs) : new InternalListView(context, attrs);
        return lv;
    }

    @Override
    protected ListView createRefreshableView(Context context, AttributeSet attrs) {
        ListView lv = this.createListView(context, attrs);
        lv.setId(16908298);
        return lv;
    }

    @Override
    protected void handleStyledAttributes(TypedArray a) {
        super.handleStyledAttributes(a);
        this.mListViewExtrasEnabled = a.getBoolean(R.styleable.PullToRefresh_ptrListViewExtrasEnabled, true);
        if (this.mListViewExtrasEnabled) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2, 1);
            FrameLayout frame = new FrameLayout(this.getContext());
            this.mHeaderLoadingView = this.createLoadingLayout(this.getContext(), PullToRefreshBase.Mode.PULL_FROM_START, a);
            this.mHeaderLoadingView.setVisibility(8);
            frame.addView((View)this.mHeaderLoadingView, (ViewGroup.LayoutParams)lp);
            ((ListView)this.mRefreshableView).addHeaderView((View)frame, null, false);
            this.mLvFooterLoadingFrame = new FrameLayout(this.getContext());
            this.mFooterLoadingView = this.createLoadingLayout(this.getContext(), PullToRefreshBase.Mode.PULL_FROM_END, a);
            this.mFooterLoadingView.setVisibility(8);
            this.mLvFooterLoadingFrame.addView((View)this.mFooterLoadingView, (ViewGroup.LayoutParams)lp);
            if (!a.hasValue(R.styleable.PullToRefresh_ptrScrollingWhileRefreshingEnabled)) {
                this.setScrollingWhileRefreshingEnabled(true);
            }
        }
    }

    protected class InternalListView
    extends ListView
    implements EmptyViewMethodAccessor {
        private boolean mAddedLvFooter;

        public InternalListView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.mAddedLvFooter = false;
        }

        protected void dispatchDraw(Canvas canvas) {
            try {
                super.dispatchDraw(canvas);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            try {
                return super.dispatchTouchEvent(ev);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void setAdapter(ListAdapter adapter) {
            if (null != PullToRefreshListView.this.mLvFooterLoadingFrame && !this.mAddedLvFooter) {
                this.addFooterView((View)PullToRefreshListView.this.mLvFooterLoadingFrame, null, false);
                this.mAddedLvFooter = true;
            }
            super.setAdapter(adapter);
        }

        @Override
        public void setEmptyView(View emptyView) {
            PullToRefreshListView.this.setEmptyView(emptyView);
        }

        @Override
        public void setEmptyViewInternal(View emptyView) {
            super.setEmptyView(emptyView);
        }
    }

    @TargetApi(value=9)
    final class InternalListViewSDK9
    extends InternalListView {
        public InternalListViewSDK9(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            boolean returnValue = super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
            OverscrollHelper.overScrollBy(PullToRefreshListView.this, deltaX, scrollX, deltaY, scrollY, isTouchEvent);
            return returnValue;
        }
    }
}

