/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.FieldViewBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import butterknife.internal.MethodViewBinding;
import butterknife.internal.ViewBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewBindings {
    private final int id;
    private final Set<FieldViewBinding> fieldBindings = new LinkedHashSet<FieldViewBinding>();
    private final LinkedHashMap<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> methodBindings = new LinkedHashMap();

    ViewBindings(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Collection<FieldViewBinding> getFieldBindings() {
        return this.fieldBindings;
    }

    public Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> getMethodBindings() {
        return this.methodBindings;
    }

    public boolean hasMethodBinding(ListenerClass listener, ListenerMethod method) {
        Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
        return methods != null && methods.containsKey(method);
    }

    public void addMethodBinding(ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
        Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
        Set<MethodViewBinding> set = null;
        if (methods == null) {
            methods = new LinkedHashMap<ListenerMethod, Set<MethodViewBinding>>();
            this.methodBindings.put(listener, methods);
        } else {
            set = methods.get(method);
        }
        if (set == null) {
            set = new LinkedHashSet<MethodViewBinding>();
            methods.put(method, set);
        }
        set.add(binding);
    }

    public void addFieldBinding(FieldViewBinding fieldBinding) {
        this.fieldBindings.add(fieldBinding);
    }

    public List<ViewBinding> getRequiredBindings() {
        ArrayList<ViewBinding> requiredViewBindings = new ArrayList<ViewBinding>();
        for (FieldViewBinding fieldViewBinding : this.fieldBindings) {
            if (!fieldViewBinding.isRequired()) continue;
            requiredViewBindings.add(fieldViewBinding);
        }
        for (Map map : this.methodBindings.values()) {
            for (Set set : map.values()) {
                for (MethodViewBinding binding : set) {
                    if (!binding.isRequired()) continue;
                    requiredViewBindings.add(binding);
                }
            }
        }
        return requiredViewBindings;
    }
}

