/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Handler;
import android.os.Looper;
import com.android.volley.Cache;
import com.android.volley.CacheDispatcher;
import com.android.volley.ExecutorDelivery;
import com.android.volley.Network;
import com.android.volley.NetworkDispatcher;
import com.android.volley.Request;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private final Map<String, Queue<Request>> mWaitingRequests = new HashMap<String, Queue<Request>>();
    private final Set<Request> mCurrentRequests = new HashSet<Request>();
    private final PriorityBlockingQueue<Request> mCacheQueue = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<Request> mNetworkQueue = new PriorityBlockingQueue();
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final Cache mCache;
    private final Network mNetwork;
    private final ResponseDelivery mDelivery;
    private NetworkDispatcher[] mDispatchers;
    private CacheDispatcher mCacheDispatcher;

    public RequestQueue(Cache cache, Network network, int threadPoolSize, ResponseDelivery delivery) {
        this.mCache = cache;
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[threadPoolSize];
        this.mDelivery = delivery;
    }

    public RequestQueue(Cache cache, Network network, int threadPoolSize) {
        this(cache, network, threadPoolSize, new ExecutorDelivery(new Handler(Looper.getMainLooper())));
    }

    public RequestQueue(Cache cache, Network network) {
        this(cache, network, 4);
    }

    public void start() {
        this.stop();
        this.mCacheDispatcher = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mCache, this.mDelivery);
        this.mCacheDispatcher.start();
        int i = 0;
        while (i < this.mDispatchers.length) {
            NetworkDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new NetworkDispatcher(this.mNetworkQueue, this.mNetwork, this.mCache, this.mDelivery);
            networkDispatcher.start();
            ++i;
        }
    }

    public void stop() {
        if (this.mCacheDispatcher != null) {
            this.mCacheDispatcher.quit();
        }
        int i = 0;
        while (i < this.mDispatchers.length) {
            if (this.mDispatchers[i] != null) {
                this.mDispatchers[i].quit();
            }
            ++i;
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    public Cache getCache() {
        return this.mCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(RequestFilter filter) {
        Set<Request> set = this.mCurrentRequests;
        synchronized (set) {
            for (Request request : this.mCurrentRequests) {
                if (!filter.apply(request)) continue;
                request.cancel();
            }
        }
    }

    public void cancelAll(final Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Cannot cancelAll with a null tag");
        }
        this.cancelAll(new RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                return request.getTag() == tag;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request add(Request request) {
        request.setRequestQueue(this);
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        if (!request.shouldCache()) {
            this.mNetworkQueue.add(request);
            return request;
        }
        object = this.mWaitingRequests;
        synchronized (object) {
            String cacheKey = request.getCacheKey();
            if (this.mWaitingRequests.containsKey(cacheKey)) {
                Queue<Request> stagedRequests = this.mWaitingRequests.get(cacheKey);
                if (stagedRequests == null) {
                    stagedRequests = new LinkedList<Request>();
                }
                stagedRequests.add(request);
                this.mWaitingRequests.put(cacheKey, stagedRequests);
                if (VolleyLog.DEBUG) {
                    VolleyLog.v("Request for cacheKey=%s is in flight, putting on hold.", cacheKey);
                }
            } else {
                this.mWaitingRequests.put(cacheKey, null);
                this.mCacheQueue.add(request);
            }
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(Request request) {
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.remove(request);
        }
        if (request.shouldCache()) {
            object = this.mWaitingRequests;
            synchronized (object) {
                String cacheKey = request.getCacheKey();
                Queue<Request> waitingRequests = this.mWaitingRequests.remove(cacheKey);
                if (waitingRequests != null) {
                    if (VolleyLog.DEBUG) {
                        VolleyLog.v("Releasing %d waiting requests for cacheKey=%s.", waitingRequests.size(), cacheKey);
                    }
                    this.mCacheQueue.addAll(waitingRequests);
                }
            }
        }
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }
}

