/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.relinker;

import android.content.Context;
import android.util.Log;
import com.getkeepsafe.relinker.ApkLibraryInstaller;
import com.getkeepsafe.relinker.MissingLibraryException;
import com.getkeepsafe.relinker.ReLinker;
import com.getkeepsafe.relinker.a;
import com.getkeepsafe.relinker.b;
import com.getkeepsafe.relinker.elf.ElfParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ReLinkerInstance {
    protected final Set<String> loadedLibraries = new HashSet<String>();
    protected final ReLinker.LibraryLoader libraryLoader;
    protected final ReLinker.LibraryInstaller libraryInstaller;
    protected boolean force;
    protected boolean recursive;
    protected ReLinker.Logger logger;

    protected ReLinkerInstance() {
        this(new a(), new ApkLibraryInstaller());
    }

    protected ReLinkerInstance(ReLinker.LibraryLoader libraryLoader, ReLinker.LibraryInstaller libraryInstaller) {
        if (libraryLoader == null) {
            throw new IllegalArgumentException("Cannot pass null library loader");
        }
        if (libraryInstaller == null) {
            throw new IllegalArgumentException("Cannot pass null library installer");
        }
        this.libraryLoader = libraryLoader;
        this.libraryInstaller = libraryInstaller;
    }

    public ReLinkerInstance log(ReLinker.Logger logger) {
        this.logger = logger;
        return this;
    }

    public ReLinkerInstance force() {
        this.force = true;
        return this;
    }

    public ReLinkerInstance recursively() {
        this.recursive = true;
        return this;
    }

    public void loadLibrary(Context context, String string) {
        this.loadLibrary(context, string, null, null);
    }

    public void loadLibrary(Context context, String string, String string2) {
        this.loadLibrary(context, string, string2, null);
    }

    public void loadLibrary(Context context, String string, ReLinker.LoadListener loadListener) {
        this.loadLibrary(context, string, null, loadListener);
    }

    public void loadLibrary(final Context context, final String string, final String string2, final ReLinker.LoadListener loadListener) {
        if (context == null) {
            throw new IllegalArgumentException("Given context is null");
        }
        if (b.isEmpty(string)) {
            throw new IllegalArgumentException("Given library is either null or empty");
        }
        this.log("Beginning load of %s...", string);
        if (loadListener == null) {
            this.a(context, string, string2);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public final void run() {
                try {
                    ReLinkerInstance.this.a(context, string, string2);
                    loadListener.success();
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    loadListener.failure(unsatisfiedLinkError);
                    return;
                }
                catch (MissingLibraryException missingLibraryException) {
                    loadListener.failure(missingLibraryException);
                    return;
                }
            }
        }).start();
    }

    private void a(Context context, String string, String string2) {
        if (this.loadedLibraries.contains(string) && !this.force) {
            this.log("%s already loaded previously!", string);
            return;
        }
        try {
            this.libraryLoader.loadLibrary(string);
            this.loadedLibraries.add(string);
            this.log("%s (%s) was loaded normally!", string, string2);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.log("Loading the library normally failed: %s", Log.getStackTraceString((Throwable)unsatisfiedLinkError));
            this.log("%s (%s) was not loaded normally, re-linking...", string, string2);
            File file = this.getWorkaroundLibFile(context, string, string2);
            if (!file.exists() || this.force) {
                if (this.force) {
                    this.log("Forcing a re-link of %s (%s)...", string, string2);
                }
                this.cleanupOldLibFiles(context, string, string2);
                this.libraryInstaller.installLibrary(context, this.libraryLoader.supportedAbis(), this.libraryLoader.mapLibraryName(string), file, this);
            }
            try {
                if (this.recursive) {
                    for (String string3 : new ElfParser(file).parseNeededDependencies()) {
                        this.loadLibrary(context, this.libraryLoader.unmapLibraryName(string3));
                    }
                }
            }
            catch (IOException iOException) {}
            this.libraryLoader.loadPath(file.getAbsolutePath());
            this.loadedLibraries.add(string);
            this.log("%s (%s) was re-linked!", string, string2);
            return;
        }
    }

    protected File getWorkaroundLibDir(Context context) {
        return context.getDir("lib", 0);
    }

    protected File getWorkaroundLibFile(Context context, String string, String string2) {
        string = this.libraryLoader.mapLibraryName(string);
        if (b.isEmpty(string2)) {
            return new File(this.getWorkaroundLibDir(context), string);
        }
        return new File(this.getWorkaroundLibDir(context), string + "." + string2);
    }

    protected void cleanupOldLibFiles(Context object, String fileArray, String string) {
        File file = this.getWorkaroundLibDir((Context)object);
        object = this.getWorkaroundLibFile((Context)object, (String)fileArray, string);
        fileArray = this.libraryLoader.mapLibraryName((String)fileArray);
        if ((fileArray = file.listFiles(new FilenameFilter((String)fileArray){
            final /* synthetic */ String aj;
            {
                this.aj = string;
            }

            @Override
            public final boolean accept(File file, String string) {
                return string.startsWith(this.aj);
            }
        })) == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!this.force && file2.getAbsolutePath().equals(((File)object).getAbsolutePath())) continue;
            file2.delete();
        }
    }

    public void log(String string, Object ... objectArray) {
        this.log(String.format(Locale.US, string, objectArray));
    }

    public void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }
}

