/*
 * Decompiled with CFR 0.152.
 */
package com.handmark.pulltorefresh.library.extras;

import android.content.Context;
import android.media.MediaPlayer;
import android.view.View;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import java.util.HashMap;

public class SoundPullEventListener<V extends View>
implements PullToRefreshBase.OnPullEventListener<V> {
    private final Context mContext;
    private final HashMap<PullToRefreshBase.State, Integer> mSoundMap;
    private MediaPlayer mCurrentMediaPlayer;

    public SoundPullEventListener(Context context) {
        this.mContext = context;
        this.mSoundMap = new HashMap();
    }

    @Override
    public final void onPullEvent(PullToRefreshBase<V> refreshView, PullToRefreshBase.State event, PullToRefreshBase.Mode direction) {
        Integer soundResIdObj = this.mSoundMap.get((Object)event);
        if (null != soundResIdObj) {
            this.playSound(soundResIdObj);
        }
    }

    public void addSoundEvent(PullToRefreshBase.State event, int resId) {
        this.mSoundMap.put(event, resId);
    }

    public void clearSounds() {
        this.mSoundMap.clear();
    }

    public MediaPlayer getCurrentMediaPlayer() {
        return this.mCurrentMediaPlayer;
    }

    private void playSound(int resId) {
        if (null != this.mCurrentMediaPlayer) {
            this.mCurrentMediaPlayer.stop();
            this.mCurrentMediaPlayer.release();
        }
        this.mCurrentMediaPlayer = MediaPlayer.create((Context)this.mContext, (int)resId);
        if (null != this.mCurrentMediaPlayer) {
            this.mCurrentMediaPlayer.start();
        }
    }
}

