/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.andreabaccega.widget.DefaultEditTextValidator;
import com.andreabaccega.widget.EditTextValidator;

public class ValidatingEditTextPreference
extends EditTextPreference {
    private EditTextValidator editTextValidator;

    public ValidatingEditTextPreference(Context context) {
        super(context);
        throw new RuntimeException("Not supported");
    }

    public ValidatingEditTextPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.editTextValidator = new DefaultEditTextValidator(this.getEditText(), attrs, context);
    }

    public ValidatingEditTextPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.editTextValidator = new DefaultEditTextValidator(this.getEditText(), attrs, context);
    }

    public EditTextValidator getEditTextValidator() {
        return this.editTextValidator;
    }

    public void setEditTextValidator(EditTextValidator editTextValidator) {
        this.editTextValidator = editTextValidator;
    }

    protected void showDialog(Bundle state) {
        super.showDialog(state);
        if (super.getDialog() instanceof AlertDialog) {
            AlertDialog theDialog = (AlertDialog)super.getDialog();
            int padding = Integer.MIN_VALUE;
            try {
                padding = ((LinearLayout)this.getEditText().getParent()).getPaddingBottom();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int originalBottomPadding = padding;
            Button b = theDialog.getButton(-1);
            ValidatingOnClickListener l = new ValidatingOnClickListener(originalBottomPadding, theDialog);
            b.setOnClickListener((View.OnClickListener)l);
            this.getEditText().setOnEditorActionListener((TextView.OnEditorActionListener)l);
        }
    }

    private final class ValidatingOnClickListener
    implements View.OnClickListener,
    TextView.OnEditorActionListener {
        private final int originalBottomPadding;
        private final AlertDialog theDialog;

        private ValidatingOnClickListener(int originalBottomPadding, AlertDialog theDialog) {
            this.originalBottomPadding = originalBottomPadding;
            this.theDialog = theDialog;
        }

        public void onClick(View view) {
            this.performValidation();
        }

        public void performValidation() {
            LinearLayout parentLayout;
            ValidatingEditTextPreference.this.getEditText().setError(null);
            if (ValidatingEditTextPreference.this.editTextValidator.testValidity()) {
                LinearLayout parentLayout2;
                this.theDialog.dismiss();
                ValidatingEditTextPreference.this.onClick((DialogInterface)this.theDialog, -1);
                if (this.originalBottomPadding != Integer.MIN_VALUE && this.originalBottomPadding == (parentLayout2 = (LinearLayout)ValidatingEditTextPreference.this.getEditText().getParent()).getPaddingBottom()) {
                    parentLayout2.setPadding(parentLayout2.getPaddingLeft(), parentLayout2.getPaddingTop(), parentLayout2.getPaddingRight(), this.originalBottomPadding);
                }
            } else if (this.originalBottomPadding != Integer.MIN_VALUE && this.originalBottomPadding == (parentLayout = (LinearLayout)ValidatingEditTextPreference.this.getEditText().getParent()).getPaddingBottom()) {
                parentLayout.setPadding(parentLayout.getPaddingLeft(), parentLayout.getPaddingTop(), parentLayout.getPaddingRight(), (int)((double)parentLayout.getPaddingBottom() + (double)ValidatingEditTextPreference.this.getEditText().getHeight() * 1.05));
            }
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            this.performValidation();
            return true;
        }
    }
}

