/*
 * Decompiled with CFR 0.152.
 */
package com.handmark.pulltorefresh.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.HorizontalScrollView;
import com.handmark.pulltorefresh.library.OverscrollHelper;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.R;

public class PullToRefreshHorizontalScrollView
extends PullToRefreshBase<HorizontalScrollView> {
    public PullToRefreshHorizontalScrollView(Context context) {
        super(context);
    }

    public PullToRefreshHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PullToRefreshHorizontalScrollView(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
    }

    public PullToRefreshHorizontalScrollView(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle style) {
        super(context, mode, style);
    }

    @Override
    public final PullToRefreshBase.Orientation getPullToRefreshScrollDirection() {
        return PullToRefreshBase.Orientation.HORIZONTAL;
    }

    @Override
    protected HorizontalScrollView createRefreshableView(Context context, AttributeSet attrs) {
        HorizontalScrollView scrollView = Build.VERSION.SDK_INT >= 9 ? new InternalHorizontalScrollViewSDK9(context, attrs) : new HorizontalScrollView(context, attrs);
        scrollView.setId(R.id.scrollview);
        return scrollView;
    }

    @Override
    protected boolean isReadyForPullStart() {
        return ((HorizontalScrollView)this.mRefreshableView).getScrollX() == 0;
    }

    @Override
    protected boolean isReadyForPullEnd() {
        View scrollViewChild = ((HorizontalScrollView)this.mRefreshableView).getChildAt(0);
        if (null != scrollViewChild) {
            return ((HorizontalScrollView)this.mRefreshableView).getScrollX() >= scrollViewChild.getWidth() - this.getWidth();
        }
        return false;
    }

    @TargetApi(value=9)
    final class InternalHorizontalScrollViewSDK9
    extends HorizontalScrollView {
        public InternalHorizontalScrollViewSDK9(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            boolean returnValue = super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
            OverscrollHelper.overScrollBy(PullToRefreshHorizontalScrollView.this, deltaX, scrollX, deltaY, scrollY, this.getScrollRange(), isTouchEvent);
            return returnValue;
        }

        private int getScrollRange() {
            int scrollRange = 0;
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                scrollRange = Math.max(0, child.getWidth() - (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()));
            }
            return scrollRange;
        }
    }
}

