/*
 * Decompiled with CFR 0.152.
 */
package com.handmark.pulltorefresh.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.handmark.pulltorefresh.library.OverscrollHelper;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.R;

public class PullToRefreshWebView
extends PullToRefreshBase<WebView> {
    private static final PullToRefreshBase.OnRefreshListener<WebView> defaultOnRefreshListener = new PullToRefreshBase.OnRefreshListener<WebView>(){

        @Override
        public void onRefresh(PullToRefreshBase<WebView> refreshView) {
            refreshView.getRefreshableView().reload();
        }
    };
    private final WebChromeClient defaultWebChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                PullToRefreshWebView.this.onRefreshComplete();
            }
        }
    };

    public PullToRefreshWebView(Context context) {
        super(context);
        this.setOnRefreshListener(defaultOnRefreshListener);
        ((WebView)this.mRefreshableView).setWebChromeClient(this.defaultWebChromeClient);
    }

    public PullToRefreshWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnRefreshListener(defaultOnRefreshListener);
        ((WebView)this.mRefreshableView).setWebChromeClient(this.defaultWebChromeClient);
    }

    public PullToRefreshWebView(Context context, PullToRefreshBase.Mode mode) {
        super(context, mode);
        this.setOnRefreshListener(defaultOnRefreshListener);
        ((WebView)this.mRefreshableView).setWebChromeClient(this.defaultWebChromeClient);
    }

    public PullToRefreshWebView(Context context, PullToRefreshBase.Mode mode, PullToRefreshBase.AnimationStyle style) {
        super(context, mode, style);
        this.setOnRefreshListener(defaultOnRefreshListener);
        ((WebView)this.mRefreshableView).setWebChromeClient(this.defaultWebChromeClient);
    }

    @Override
    public final PullToRefreshBase.Orientation getPullToRefreshScrollDirection() {
        return PullToRefreshBase.Orientation.VERTICAL;
    }

    @Override
    protected WebView createRefreshableView(Context context, AttributeSet attrs) {
        WebView webView = Build.VERSION.SDK_INT >= 9 ? new InternalWebViewSDK9(context, attrs) : new WebView(context, attrs);
        webView.setId(R.id.webview);
        return webView;
    }

    @Override
    protected boolean isReadyForPullStart() {
        return ((WebView)this.mRefreshableView).getScrollY() == 0;
    }

    @Override
    protected boolean isReadyForPullEnd() {
        float exactContentHeight = FloatMath.floor((float)((float)((WebView)this.mRefreshableView).getContentHeight() * ((WebView)this.mRefreshableView).getScale()));
        return (float)((WebView)this.mRefreshableView).getScrollY() >= exactContentHeight - (float)((WebView)this.mRefreshableView).getHeight();
    }

    @Override
    protected void onPtrRestoreInstanceState(Bundle savedInstanceState) {
        super.onPtrRestoreInstanceState(savedInstanceState);
        ((WebView)this.mRefreshableView).restoreState(savedInstanceState);
    }

    @Override
    protected void onPtrSaveInstanceState(Bundle saveState) {
        super.onPtrSaveInstanceState(saveState);
        ((WebView)this.mRefreshableView).saveState(saveState);
    }

    @TargetApi(value=9)
    final class InternalWebViewSDK9
    extends WebView {
        static final int OVERSCROLL_FUZZY_THRESHOLD = 2;
        static final float OVERSCROLL_SCALE_FACTOR = 1.5f;

        public InternalWebViewSDK9(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            boolean returnValue = super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
            OverscrollHelper.overScrollBy(PullToRefreshWebView.this, deltaX, scrollX, deltaY, scrollY, this.getScrollRange(), 2, 1.5f, isTouchEvent);
            return returnValue;
        }

        private int getScrollRange() {
            return (int)Math.max(0.0f, FloatMath.floor((float)((float)((WebView)PullToRefreshWebView.this.mRefreshableView).getContentHeight() * ((WebView)PullToRefreshWebView.this.mRefreshableView).getScale())) - (float)(this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()));
        }
    }
}

