/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.appsearch.patchupdate;

import com.baidu.appsearch.patchupdate.patch.ByteBufferSeekableSource;
import com.baidu.appsearch.patchupdate.patch.PatchException;
import com.baidu.appsearch.patchupdate.patch.RandomAccessFileSeekableSource;
import com.baidu.appsearch.patchupdate.patch.SeekableSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;

public class GDiffPatcher {
    private static final boolean DEBUG = false;
    private static final String TAG = "GDiffPatcher";
    public static final int CHUNK_SIZE = Short.MAX_VALUE;
    public static final int ONE_MB = 0x100000;
    public static final int HALF_MB = 5120000;
    public static final byte EOF = 0;
    public static final int DATA_MAX = 246;
    public static final int DATA_USHORT = 247;
    public static final int DATA_INT = 248;
    public static final int COPY_UBYTE_UBYTE = 244;
    public static final int COPY_UBYTE_USHORT = 245;
    public static final int COPY_UBYTE_INT = 246;
    public static final int COPY_USHORT_UBYTE = 249;
    public static final int COPY_USHORT_USHORT = 250;
    public static final int COPY_USHORT_INT = 251;
    public static final int COPY_INT_UBYTE = 252;
    public static final int COPY_INT_USHORT = 253;
    public static final int COPY_INT_INT = 254;
    public static final int COPY_LONG_INT = 255;
    public static final int DEFAULT_ZERO_MIN_BLOCK = 10;
    public static final double DEFAULT_ZERO_RATIO = 0.9;
    private static final int BUF_SIZE = 5120;
    private ByteBuffer buf = ByteBuffer.allocate(5120);
    private byte[] buf2 = this.buf.array();
    private boolean differential = false;
    private long currentOffset = 0L;
    private int dataMax = 246;
    public long totalLength = 0L;
    private byte[] mDatas = new byte[0x100000];
    private int datalength = 0;

    public void patch(File file, File file2, File file3) throws IOException {
        RandomAccessFileSeekableSource randomAccessFileSeekableSource = new RandomAccessFileSeekableSource(new RandomAccessFile(file, "r"));
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        try {
            this.patch(randomAccessFileSeekableSource, (InputStream)fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            randomAccessFileSeekableSource.close();
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file3.length();
        }
    }

    public void patch(byte[] byArray, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.patch(new ByteBufferSeekableSource(byArray), inputStream, outputStream);
    }

    public byte[] patch(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.patch(byArray, (InputStream)new ByteArrayInputStream(byArray2), (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void patch(SeekableSource seekableSource, InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream, 5120000));
        if (dataInputStream.readUnsignedByte() != 209 || dataInputStream.readUnsignedByte() != 255 || dataInputStream.readUnsignedByte() != 209 || dataInputStream.readUnsignedByte() != 255) {
            throw new PatchException("magic string not found, aborting!");
        }
        int n2 = dataInputStream.readUnsignedByte();
        if (n2 == 5) {
            this.differential = true;
            this.dataMax = 243;
        } else if (n2 != 4) {
            throw new PatchException("magic string not found, aborting!");
        }
        this.totalLength = 0L;
        block14: while ((n = dataInputStream.readUnsignedByte()) != 0) {
            if (n <= this.dataMax) {
                this.append(n, dataInputStream, dataOutputStream);
                this.totalLength += (long)n;
                continue;
            }
            switch (n) {
                case 247: {
                    int n3 = dataInputStream.readUnsignedShort();
                    this.append(n3, dataInputStream, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 248: {
                    int n3 = dataInputStream.readInt();
                    this.append(n3, dataInputStream, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 249: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readShort();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedShort();
                    }
                    int n3 = dataInputStream.readUnsignedByte();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 250: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readShort();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedShort();
                    }
                    int n3 = dataInputStream.readUnsignedShort();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 251: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readShort();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedShort();
                    }
                    int n3 = dataInputStream.readInt();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 244: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readByte();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedByte();
                    }
                    int n3 = dataInputStream.readUnsignedByte();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 245: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readByte();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedByte();
                    }
                    int n3 = dataInputStream.readUnsignedShort();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 246: {
                    long l;
                    if (this.differential) {
                        l = dataInputStream.readByte();
                        this.currentOffset = l += this.currentOffset;
                    } else {
                        l = dataInputStream.readUnsignedByte();
                    }
                    int n3 = dataInputStream.readInt();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 252: {
                    long l = dataInputStream.readInt();
                    if (this.differential) {
                        this.currentOffset = l += this.currentOffset;
                    }
                    int n3 = dataInputStream.readUnsignedByte();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 253: {
                    long l = dataInputStream.readInt();
                    if (this.differential) {
                        this.currentOffset = l += this.currentOffset;
                    }
                    int n3 = dataInputStream.readUnsignedShort();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 254: {
                    long l = dataInputStream.readInt();
                    if (this.differential) {
                        this.currentOffset = l += this.currentOffset;
                    }
                    int n3 = dataInputStream.readInt();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
                case 255: {
                    long l = dataInputStream.readLong();
                    if (this.differential) {
                        this.currentOffset = l += this.currentOffset;
                    }
                    int n3 = dataInputStream.readInt();
                    this.copy(l, n3, seekableSource, dataOutputStream);
                    this.totalLength += (long)n3;
                    continue block14;
                }
            }
            throw new IllegalStateException("command " + n);
        }
        this.flush(dataOutputStream);
    }

    void copy(long l, int n, SeekableSource seekableSource, OutputStream outputStream) throws IOException {
        seekableSource.seek(l);
        while (n > 0) {
            int n2 = Math.min(this.buf.capacity(), n);
            this.buf.clear().limit(n2);
            int n3 = seekableSource.read(this.buf);
            if (n3 == -1) {
                throw new EOFException("in copy " + l + " " + n);
            }
            this.writeToBuffer(this.buf.array(), 0, n3, outputStream);
            n -= n3;
        }
    }

    private void writeToBuffer(byte[] byArray, int n, int n2, OutputStream outputStream) {
        try {
            if (this.datalength + n2 >= this.mDatas.length) {
                outputStream.write(this.mDatas, 0, this.datalength);
                this.datalength = 0;
                System.arraycopy(byArray, 0, this.mDatas, 0, n2);
                this.datalength = n2;
            } else {
                if (this.datalength == 0) {
                    System.arraycopy(byArray, 0, this.mDatas, 0, n2);
                } else {
                    System.arraycopy(byArray, 0, this.mDatas, this.datalength, n2);
                }
                this.datalength += n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void append(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        while (n > 0) {
            int n2 = Math.min(this.buf2.length, n);
            int n3 = inputStream.read(this.buf2, 0, n2);
            if (n3 == -1) {
                throw new EOFException("cannot read " + n);
            }
            this.writeToBuffer(this.buf2, 0, n3, outputStream);
            n -= n3;
        }
    }

    void flush(OutputStream outputStream) throws IOException {
        if (this.datalength > 0) {
            outputStream.write(this.mDatas, 0, this.datalength);
            this.datalength = 0;
        }
        outputStream.flush();
    }

    public static void unGZip(String string, String string2) {
        long l = System.currentTimeMillis();
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(gZIPInputStream);
            byte[] byArray = new byte[10240];
            int n = -1;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileInputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

