/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class BaseMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final Map<K, Reference<V>> softMap = Collections.synchronizedMap(new HashMap());

    @Override
    public V get(K key) {
        V result = null;
        Reference<V> reference = this.softMap.get(key);
        if (reference != null) {
            result = reference.get();
        }
        return result;
    }

    @Override
    public boolean put(K key, V value) {
        this.softMap.put(key, this.createReference(value));
        return true;
    }

    @Override
    public void remove(K key) {
        this.softMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> keys() {
        Map<K, Reference<V>> map = this.softMap;
        synchronized (map) {
            return new HashSet<K>(this.softMap.keySet());
        }
    }

    @Override
    public void clear() {
        this.softMap.clear();
    }

    protected abstract Reference<V> createReference(V var1);
}

