/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Comparator;

public class FuzzyKeyMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final MemoryCacheAware<K, V> cache;
    private final Comparator<K> keyComparator;

    public FuzzyKeyMemoryCache(MemoryCacheAware<K, V> cache, Comparator<K> keyComparator) {
        this.cache = cache;
        this.keyComparator = keyComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) {
        MemoryCacheAware<K, V> memoryCacheAware = this.cache;
        synchronized (memoryCacheAware) {
            Object keyToRemove = null;
            for (K cacheKey : this.cache.keys()) {
                if (this.keyComparator.compare(key, cacheKey) != 0) continue;
                keyToRemove = cacheKey;
                break;
            }
            if (keyToRemove != null) {
                this.cache.remove(keyToRemove);
            }
        }
        return this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<K> keys() {
        return this.cache.keys();
    }
}

