/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;

public final class ImageSizeUtils {
    private ImageSizeUtils() {
    }

    public static ImageSize defineTargetSizeForView(ImageAware imageAware, ImageSize maxImageSize) {
        int height;
        int width = imageAware.getWidth();
        if (width <= 0) {
            width = maxImageSize.getWidth();
        }
        if ((height = imageAware.getHeight()) <= 0) {
            height = maxImageSize.getHeight();
        }
        return new ImageSize(width, height);
    }

    public static int computeImageSampleSize(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean powerOf2Scale) {
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        int scale = 1;
        int widthScale = srcWidth / targetWidth;
        int heightScale = srcHeight / targetHeight;
        switch (viewScaleType) {
            case FIT_INSIDE: {
                if (powerOf2Scale) {
                    while (srcWidth / 2 >= targetWidth || srcHeight / 2 >= targetHeight) {
                        srcWidth /= 2;
                        srcHeight /= 2;
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.max(widthScale, heightScale);
                break;
            }
            case CROP: {
                if (powerOf2Scale) {
                    while (srcWidth / 2 >= targetWidth && srcHeight / 2 >= targetHeight) {
                        srcWidth /= 2;
                        srcHeight /= 2;
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.min(widthScale, heightScale);
            }
        }
        if (scale < 1) {
            scale = 1;
        }
        return scale;
    }

    public static float computeImageScale(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean stretch) {
        int destHeight;
        int destWidth;
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        float widthScale = (float)srcWidth / (float)targetWidth;
        float heightScale = (float)srcHeight / (float)targetHeight;
        if (viewScaleType == ViewScaleType.FIT_INSIDE && widthScale >= heightScale || viewScaleType == ViewScaleType.CROP && widthScale < heightScale) {
            destWidth = targetWidth;
            destHeight = (int)((float)srcHeight / widthScale);
        } else {
            destWidth = (int)((float)srcWidth / heightScale);
            destHeight = targetHeight;
        }
        float scale = 1.0f;
        if (!stretch && destWidth < srcWidth && destHeight < srcHeight || stretch && destWidth != srcWidth && destHeight != srcHeight) {
            scale = (float)destWidth / (float)srcWidth;
        }
        return scale;
    }
}

