/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.pay;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.api.share.IWeiboDownloadListener;
import com.sina.weibo.sdk.exception.WeiboShareException;
import com.sina.weibo.sdk.utils.AidTask;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;

public class WeiboPayImpl {
    private static final String TAG = WeiboPayImpl.class.getName();
    private Context mContext;
    private String mAppKey;
    private WeiboAppManager.WeiboInfo mWeiboInfo = null;
    private boolean mNeedDownloadWeibo = true;
    private IWeiboDownloadListener mDownloadListener;
    private Dialog mDownloadConfirmDialog = null;

    public WeiboPayImpl(Context context, String appKey, boolean needDownloadWeibo) {
        this.mContext = context;
        this.mAppKey = appKey;
        this.mWeiboInfo = WeiboAppManager.getInstance(context).getWeiboInfo();
        if (this.mWeiboInfo != null) {
            LogUtil.d(TAG, this.mWeiboInfo.toString());
        } else {
            LogUtil.d(TAG, "WeiboInfo is null");
        }
        AidTask.getInstance(context).aidTaskInit(appKey);
    }

    public boolean launchWeiboPay(Activity act, String payArgs) {
        Bundle bundle = new Bundle();
        bundle.putString("rawdata", payArgs);
        bundle.putInt("_weibo_command_type", 4);
        bundle.putString("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
        return this.launchWeiboActivity(act, "com.sina.weibo.sdk.action.ACTION_WEIBO_PAY_ACTIVITY", this.mWeiboInfo.getPackageName(), this.mAppKey, bundle);
    }

    private boolean launchWeiboActivity(Activity activity, String action, String pkgName, String appkey, Bundle data) {
        if (activity == null || TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)pkgName) || TextUtils.isEmpty((CharSequence)appkey)) {
            LogUtil.e(TAG, "launchWeiboActivity fail, invalid arguments");
            return false;
        }
        Intent intent = new Intent();
        intent.setPackage(pkgName);
        intent.setAction(action);
        String appPackage = activity.getPackageName();
        intent.putExtra("_weibo_sdkVersion", "0031405000");
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", appkey);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign((Context)activity, appPackage)));
        if (data != null) {
            intent.putExtras(data);
        }
        try {
            LogUtil.d(TAG, "launchWeiboActivity intent=" + intent + ", extra=" + intent.getExtras());
            activity.startActivityForResult(intent, 765);
        }
        catch (ActivityNotFoundException e) {
            LogUtil.e(TAG, e.getMessage());
            return false;
        }
        return true;
    }

    public int getWeiboAppSupportAPI() {
        return this.mWeiboInfo == null || !this.mWeiboInfo.isLegal() ? -1 : this.mWeiboInfo.getSupportApi();
    }

    public boolean isWeiboAppInstalled() {
        return true;
    }

    public boolean isWeiboAppSupportAPI() {
        return this.getWeiboAppSupportAPI() >= 10350;
    }

    public boolean isSupportWeiboPay() {
        return this.getWeiboAppSupportAPI() >= 10353;
    }

    public void registerWeiboDownloadListener(IWeiboDownloadListener listener) {
        this.mDownloadListener = listener;
    }

    private boolean checkEnvironment(boolean bShowDownloadDialog) throws WeiboShareException {
        return true;
    }
}

