/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.sina.weibo.sdk.statistic.EventLog;
import com.sina.weibo.sdk.statistic.LogFileUtil;
import com.sina.weibo.sdk.statistic.PageLog;
import com.sina.weibo.sdk.utils.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class LogBuilder {
    public static final String KEY_TYPE = "type";
    public static final String KEY_AID = "aid";
    public static final String KEY_APPKEY = "appkey";
    public static final String KEY_PLATFORM = "platform";
    public static final String KEY_PACKAGE_NAME = "packagename";
    public static final String KEY_HASH = "key_hash";
    public static final String KEY_VERSION = "version";
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_START_TIME = "starttime";
    public static final String KEY_END_TIME = "endtime";
    private static final String KEY_PAGE_ID = "page_id";
    private static final String KEY_TIME = "time";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_EVENT_ID = "event_id";
    private static final String KEY_EXTEND = "extend";
    private static final String APPKEY = "WEIBO_APPKEY";
    private static final String CHANNEL = "WEIBO_CHANNEL";
    public static final long MAX_INTERVAL = 86400000L;
    private static final int MAX_COUNT = 500;

    LogBuilder() {
    }

    public static String getAppKey(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo appInfo = pm.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null) {
                Object appkey = appInfo.metaData.get(APPKEY);
                if (appkey != null) {
                    LogUtil.i("WBAgent", "APPKEY: " + String.valueOf(appkey));
                    return String.valueOf(appkey);
                }
                LogUtil.e("WBAgent", "Could not read WEIBO_APPKEY meta-data from AndroidManifest.xml.");
            }
        }
        catch (Exception ex) {
            LogUtil.e("WBAgent", "Could not read WEIBO_APPKEY meta-data from AndroidManifest.xml." + ex);
        }
        return null;
    }

    public static String getChannel(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo appInfo = pm.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null) {
                String str = appInfo.metaData.getString(CHANNEL);
                if (str != null) {
                    LogUtil.i("WBAgent", "CHANNEL: " + str.trim());
                    return str.trim();
                }
                LogUtil.e("WBAgent", "Could not read WEIBO_CHANNEL meta-data from AndroidManifest.xml.");
            }
        }
        catch (Exception ex) {
            LogUtil.e("WBAgent", "Could not read WEIBO_CHANNEL meta-data from AndroidManifest.xml." + ex);
        }
        return null;
    }

    public static String getVersion(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pkg = pm.getPackageInfo(context.getPackageName(), 0);
            LogUtil.i("WBAgent", "versionName: " + pkg.versionName);
            return pkg.versionName;
        }
        catch (PackageManager.NameNotFoundException ex) {
            LogUtil.e("WBAgent", "Could not read versionName from AndroidManifest.xml." + (Object)((Object)ex));
            return null;
        }
    }

    public static String getPageLogs(List<PageLog> pages) {
        StringBuilder logs = new StringBuilder();
        for (PageLog page : pages) {
            logs.append(LogBuilder.getLogInfo(page).toString()).append(",");
        }
        return logs.toString();
    }

    private static JSONObject getLogInfo(PageLog page) {
        JSONObject json = new JSONObject();
        try {
            switch (page.getType()) {
                case SESSION_START: {
                    json.put(KEY_TYPE, 0);
                    json.put(KEY_TIME, page.getStartTime() / 1000L);
                    break;
                }
                case SESSION_END: {
                    json.put(KEY_TYPE, 1);
                    json.put(KEY_TIME, page.getEndTime() / 1000L);
                    json.put(KEY_DURATION, page.getDuration() / 1000L);
                    break;
                }
                case FRAGMENT: {
                    json.put(KEY_TYPE, 2);
                    json.put(KEY_PAGE_ID, (Object)page.getPage_id());
                    json.put(KEY_TIME, page.getStartTime() / 1000L);
                    json.put(KEY_DURATION, page.getDuration() / 1000L);
                    break;
                }
                case EVENT: {
                    json.put(KEY_TYPE, 3);
                    json.put(KEY_PAGE_ID, (Object)page.getPage_id());
                    json.put(KEY_TIME, page.getStartTime() / 1000L);
                    LogBuilder.addEventData(json, (EventLog)page);
                    break;
                }
                case ACTIVITY: {
                    json.put(KEY_TYPE, 4);
                    json.put(KEY_PAGE_ID, (Object)page.getPage_id());
                    json.put(KEY_TIME, page.getStartTime() / 1000L);
                    json.put(KEY_DURATION, page.getDuration() / 1000L);
                    break;
                }
            }
        }
        catch (Exception ex) {
            LogUtil.e("WBAgent", "get page log error." + ex);
        }
        return json;
    }

    private static JSONObject addEventData(JSONObject json, EventLog event) {
        try {
            json.put(KEY_EVENT_ID, (Object)event.getEvent_id());
            if (event.getExtend() != null) {
                Map<String, String> extend = event.getExtend();
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (String key : extend.keySet()) {
                    if (count >= 10) break;
                    if (TextUtils.isEmpty((CharSequence)extend.get(key))) continue;
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(key).append(":").append(extend.get(key));
                    ++count;
                }
                json.put(KEY_EXTEND, (Object)sb.toString());
            }
        }
        catch (Exception ex) {
            LogUtil.e("WBAgent", "add event log error." + ex);
        }
        return json;
    }

    public static List<JSONArray> getValidUploadLogs(String memoryLogs) {
        String applogs = LogBuilder.buildUploadLogs(memoryLogs);
        if (TextUtils.isEmpty((CharSequence)applogs)) {
            return null;
        }
        ArrayList<JSONArray> listValidlogs = new ArrayList<JSONArray>();
        JSONArray validlogs = new JSONArray();
        int count = 0;
        long curTime = System.currentTimeMillis();
        try {
            JSONObject json = new JSONObject(applogs);
            JSONArray jsonLogs = json.getJSONArray("applogs");
            int i = 0;
            while (i < jsonLogs.length()) {
                JSONObject log = jsonLogs.getJSONObject(i);
                if (LogBuilder.isDataValid(curTime, log.getLong(KEY_TIME) * 1000L)) {
                    if (count < 500) {
                        validlogs.put((Object)log);
                        ++count;
                    } else {
                        listValidlogs.add(validlogs);
                        validlogs = new JSONArray();
                        count = 0;
                    }
                }
                ++i;
            }
            if (validlogs.length() > 0) {
                listValidlogs.add(validlogs);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return listValidlogs;
    }

    private static String buildUploadLogs(String memoryLogs) {
        String localLogs = LogFileUtil.getAppLogs(LogFileUtil.getAppLogPath("app_logs"));
        if (TextUtils.isEmpty((CharSequence)localLogs) && TextUtils.isEmpty((CharSequence)memoryLogs)) {
            return null;
        }
        StringBuilder applogs = new StringBuilder();
        applogs.append("{applogs:[");
        if (!TextUtils.isEmpty((CharSequence)localLogs)) {
            applogs.append(localLogs);
        }
        if (!TextUtils.isEmpty((CharSequence)memoryLogs)) {
            applogs.append(memoryLogs);
        }
        if (applogs.charAt(applogs.length() - 1) == ',') {
            applogs.replace(applogs.length() - 1, applogs.length(), "");
        }
        applogs.append("]}");
        return applogs.toString();
    }

    private static boolean isDataValid(long curTime, long actTime) {
        return curTime - actTime < 86400000L;
    }
}

