/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

public class ChatManager
extends Manager {
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static boolean defaultIsNormalInclude = true;
    private static MatchMode defaultMatchMode = MatchMode.BARE_JID;
    private boolean normalIncluded = defaultIsNormalInclude;
    private MatchMode matchMode = defaultMatchMode;
    private Map<String, Chat> threadChats = Collections.synchronizedMap(new HashMap());
    private Map<String, Chat> jidChats = Collections.synchronizedMap(new HashMap());
    private Map<String, Chat> baseJidChats = Collections.synchronizedMap(new HashMap());
    private Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private Map<PacketInterceptor, PacketFilter> interceptors = new WeakHashMap<PacketInterceptor, PacketFilter>();

    public static synchronized ChatManager getInstanceFor(XMPPConnection xMPPConnection) {
        ChatManager chatManager = INSTANCES.get(xMPPConnection);
        if (chatManager == null) {
            chatManager = new ChatManager(xMPPConnection);
        }
        return chatManager;
    }

    private ChatManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        PacketFilter packetFilter = new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                if (!(packet instanceof Message)) {
                    return false;
                }
                Message.Type type = ((Message)packet).getType();
                return type == Message.Type.chat || ChatManager.this.normalIncluded && type == Message.Type.normal;
            }
        };
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                Chat chat = message.getThread() == null ? ChatManager.this.getUserChat(message.getFrom()) : ChatManager.this.getThreadChat(message.getThread());
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                if (chat == null) {
                    return;
                }
                ChatManager.this.deliverMessage(chat, message);
            }
        }, packetFilter);
        INSTANCES.put(xMPPConnection, this);
    }

    public boolean isNormalIncluded() {
        return this.normalIncluded;
    }

    public void setNormalIncluded(boolean bl) {
        this.normalIncluded = bl;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public Chat createChat(String string, MessageListener messageListener) {
        return this.createChat(string, null, messageListener);
    }

    public Chat createChat(String string, String string2, MessageListener messageListener) {
        Chat chat;
        if (string2 == null) {
            string2 = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(string2)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(string, string2, true);
        chat.addMessageListener(messageListener);
        return chat;
    }

    private Chat createChat(String string, String string2, boolean bl) {
        Chat chat = new Chat(this, string, string2);
        this.threadChats.put(string2, chat);
        this.jidChats.put(string, chat);
        this.baseJidChats.put(StringUtils.parseBareAddress(string), chat);
        for (ChatManagerListener chatManagerListener : this.chatManagerListeners) {
            chatManagerListener.chatCreated(chat, bl);
        }
        return chat;
    }

    void closeChat(Chat chat) {
        this.threadChats.remove(chat.getThreadID());
        String string = chat.getParticipant();
        this.jidChats.remove(string);
        this.baseJidChats.remove(StringUtils.parseBareAddress(string));
    }

    private Chat createChat(Message message) {
        String string = message.getFrom();
        if (string == null) {
            return null;
        }
        String string2 = message.getThread();
        if (string2 == null) {
            string2 = ChatManager.nextID();
        }
        return this.createChat(string, string2, false);
    }

    private Chat getUserChat(String string) {
        if (this.matchMode == MatchMode.NONE) {
            return null;
        }
        if (string == null) {
            return null;
        }
        Chat chat = this.jidChats.get(string);
        if (chat == null && this.matchMode == MatchMode.BARE_JID) {
            chat = this.baseJidChats.get(StringUtils.parseBareAddress(string));
        }
        return chat;
    }

    public Chat getThreadChat(String string) {
        return this.threadChats.get(string);
    }

    public void addChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.add(chatManagerListener);
    }

    public void removeChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.remove(chatManagerListener);
    }

    public Collection<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableCollection(this.chatManagerListeners);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) throws SmackException.NotConnectedException {
        for (Map.Entry<PacketInterceptor, PacketFilter> entry : this.interceptors.entrySet()) {
            PacketFilter packetFilter = entry.getValue();
            if (packetFilter == null || !packetFilter.accept(message)) continue;
            entry.getKey().interceptPacket(message);
        }
        if (message.getFrom() == null) {
            message.setFrom(this.connection().getUser());
        }
        this.connection().sendPacket(message);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection().createPacketCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), FromMatchesFilter.create(chat.getParticipant())));
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor) {
        this.addOutgoingMessageInterceptor(packetInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor != null) {
            this.interceptors.put(packetInterceptor, packetFilter);
        }
    }

    private static String nextID() {
        return UUID.randomUUID().toString();
    }

    public static void setDefaultMatchMode(MatchMode matchMode) {
        defaultMatchMode = matchMode;
    }

    public static void setDefaultIsNormalIncluded(boolean bl) {
        defaultIsNormalInclude = bl;
    }

    public static enum MatchMode {
        NONE,
        SUPPLIED_JID,
        BARE_JID;

    }
}

