/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.RosterStore;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class ConnectionConfiguration
implements Cloneable {
    private String serviceName;
    protected List<HostAddress> hostAddresses;
    private String keystorePath;
    private String keystoreType;
    private String pkcs11Library;
    private SSLContext customSSLContext;
    private boolean compressionEnabled = false;
    private CallbackHandler callbackHandler;
    private boolean debuggerEnabled = SmackConfiguration.DEBUG_ENABLED;
    private boolean reconnectionAllowed = true;
    private SocketFactory socketFactory;
    private String username;
    private String password;
    private String resource;
    private boolean sendPresence = true;
    private boolean rosterLoadedAtLogin = true;
    private boolean legacySessionDisabled = false;
    private boolean useDnsSrvRr = true;
    private SecurityMode securityMode = SecurityMode.enabled;
    private HostnameVerifier hostnameVerifier;
    private RosterStore rosterStore;
    protected ProxyInfo proxy;

    public ConnectionConfiguration(String string) {
        this.init(string, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, ProxyInfo proxyInfo) {
        this.init(string, proxyInfo);
    }

    public ConnectionConfiguration(String string, int n, String string2) {
        this.initHostAddresses(string, n);
        this.init(string2, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, int n, String string2, ProxyInfo proxyInfo) {
        this.initHostAddresses(string, n);
        this.init(string2, proxyInfo);
    }

    public ConnectionConfiguration(String string, int n) {
        this.initHostAddresses(string, n);
        this.init(string, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, int n, ProxyInfo proxyInfo) {
        this.initHostAddresses(string, n);
        this.init(string, proxyInfo);
    }

    protected void init(String string, ProxyInfo proxyInfo) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("serviceName must not be the empty String");
        }
        this.serviceName = string;
        this.proxy = proxyInfo;
        this.keystorePath = System.getProperty("javax.net.ssl.keyStore");
        this.keystoreType = "jks";
        this.pkcs11Library = "pkcs11.config";
        this.socketFactory = proxyInfo.getSocketFactory();
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String string) {
        this.keystorePath = string;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String string) {
        this.keystoreType = string;
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public void setPKCS11Library(String string) {
        this.pkcs11Library = string;
    }

    public SSLContext getCustomSSLContext() {
        return this.customSSLContext;
    }

    public void setCustomSSLContext(SSLContext sSLContext) {
        this.customSSLContext = sSLContext;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean bl) {
        this.compressionEnabled = bl;
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public void setDebuggerEnabled(boolean bl) {
        this.debuggerEnabled = bl;
    }

    public void setReconnectionAllowed(boolean bl) {
        this.reconnectionAllowed = bl;
    }

    public boolean isReconnectionAllowed() {
        return this.reconnectionAllowed;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSendPresence(boolean bl) {
        this.sendPresence = bl;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    public void setRosterLoadedAtLogin(boolean bl) {
        this.rosterLoadedAtLogin = bl;
    }

    public boolean isLegacySessionDisabled() {
        return this.legacySessionDisabled;
    }

    public void setLegacySessionDisabled(boolean bl) {
        this.legacySessionDisabled = bl;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public List<HostAddress> getHostAddresses() {
        return Collections.unmodifiableList(this.hostAddresses);
    }

    public void setRosterStore(RosterStore rosterStore) {
        this.rosterStore = rosterStore;
    }

    public RosterStore getRosterStore() {
        return this.rosterStore;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    void setLoginInfo(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        this.resource = string3;
    }

    void maybeResolveDns() throws Exception {
        if (!this.useDnsSrvRr) {
            return;
        }
        this.hostAddresses = DNSUtil.resolveXMPPDomain(this.serviceName);
    }

    private void initHostAddresses(String string, int n) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("host must not be the empty String");
        }
        this.hostAddresses = new ArrayList<HostAddress>(1);
        HostAddress hostAddress = new HostAddress(string, n);
        this.hostAddresses.add(hostAddress);
        this.useDnsSrvRr = false;
    }

    public static enum SecurityMode {
        required,
        enabled,
        disabled;

    }
}

