/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.RosterStore;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.Base32Encoder;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DirectoryRosterStore
implements RosterStore {
    private final File fileDir;
    private static final String ENTRY_PREFIX = "entry-";
    private static final String VERSION_FILE_NAME = "__version__";
    private static final String STORE_ID = "DEFAULT_ROSTER_STORE";
    private static final Logger LOGGER = Logger.getLogger(DirectoryRosterStore.class.getName());
    private static final FileFilter rosterDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.startsWith(DirectoryRosterStore.ENTRY_PREFIX);
        }
    };

    private DirectoryRosterStore(File file) {
        this.fileDir = file;
    }

    public static DirectoryRosterStore init(File file) {
        DirectoryRosterStore directoryRosterStore = new DirectoryRosterStore(file);
        if (directoryRosterStore.setRosterVersion("")) {
            return directoryRosterStore;
        }
        return null;
    }

    public static DirectoryRosterStore open(File file) {
        DirectoryRosterStore directoryRosterStore = new DirectoryRosterStore(file);
        String string = FileUtils.readFile(directoryRosterStore.getVersionFile());
        if (string != null && string.startsWith("DEFAULT_ROSTER_STORE\n")) {
            return directoryRosterStore;
        }
        return null;
    }

    private File getVersionFile() {
        return new File(this.fileDir, VERSION_FILE_NAME);
    }

    public List<RosterPacket.Item> getEntries() {
        ArrayList<RosterPacket.Item> arrayList = new ArrayList<RosterPacket.Item>();
        for (File file : this.fileDir.listFiles(rosterDirFilter)) {
            RosterPacket.Item item = this.readEntry(file);
            if (item == null) {
                this.log("Roster store file '" + file + "' is invalid.");
                continue;
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    @Override
    public RosterPacket.Item getEntry(String string) {
        return this.readEntry(this.getBareJidFile(string));
    }

    @Override
    public String getRosterVersion() {
        String string = FileUtils.readFile(this.getVersionFile());
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\n", 2);
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[1];
    }

    private boolean setRosterVersion(String string) {
        return FileUtils.writeFile(this.getVersionFile(), "DEFAULT_ROSTER_STORE\n" + string);
    }

    @Override
    public boolean addEntry(RosterPacket.Item item, String string) {
        return this.addEntryRaw(item) && this.setRosterVersion(string);
    }

    @Override
    public boolean removeEntry(String string, String string2) {
        return this.getBareJidFile(string).delete() && this.setRosterVersion(string2);
    }

    @Override
    public boolean resetEntries(Collection<RosterPacket.Item> collection, String string) {
        for (File file : this.fileDir.listFiles(rosterDirFilter)) {
            file.delete();
        }
        for (RosterPacket.Item item : collection) {
            if (this.addEntryRaw(item)) continue;
            return false;
        }
        return this.setRosterVersion(string);
    }

    private RosterPacket.Item readEntry(File file) {
        Object object;
        String string = FileUtils.readFile(file);
        if (string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = XmlPullParserFactory.newInstance().newPullParser();
            object.setInput((Reader)new StringReader(string));
            boolean bl = false;
            while (!bl) {
                int n = object.next();
                String string6 = object.getName();
                if (n == 2) {
                    if (string6.equals("item")) {
                        string5 = null;
                        string4 = null;
                        string3 = null;
                        string2 = null;
                        continue;
                    }
                    if (string6.equals("user")) {
                        object.next();
                        string2 = object.getText();
                        continue;
                    }
                    if (string6.equals("name")) {
                        object.next();
                        string3 = object.getText();
                        continue;
                    }
                    if (string6.equals("type")) {
                        object.next();
                        string4 = object.getText();
                        continue;
                    }
                    if (string6.equals("status")) {
                        object.next();
                        string5 = object.getText();
                        continue;
                    }
                    if (!string6.equals("group")) continue;
                    object.next();
                    object.next();
                    String string7 = object.getText();
                    if (string7 != null) {
                        arrayList.add(string7);
                        continue;
                    }
                    this.log("Invalid group entry in store entry file " + file);
                    continue;
                }
                if (n != 3 || !string6.equals("item")) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "readEntry()", iOException);
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            this.log("Invalid group entry in store entry file " + file);
            LOGGER.log(Level.SEVERE, "readEntry()", xmlPullParserException);
            return null;
        }
        if (string2 == null) {
            return null;
        }
        object = new RosterPacket.Item(string2, string3);
        for (String string8 : arrayList) {
            ((RosterPacket.Item)object).addGroupName(string8);
        }
        if (string4 != null) {
            try {
                ((RosterPacket.Item)object).setItemType(RosterPacket.ItemType.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log("Invalid type in store entry file " + file);
                return null;
            }
            if (string5 != null) {
                Object object2 = RosterPacket.ItemStatus.fromString(string5);
                if (object2 == null) {
                    this.log("Invalid status in store entry file " + file);
                    return null;
                }
                ((RosterPacket.Item)object).setItemStatus((RosterPacket.ItemStatus)((Object)object2));
            }
        }
        return object;
    }

    private boolean addEntryRaw(RosterPacket.Item item) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.openElement("item");
        xmlStringBuilder.element("user", item.getUser());
        xmlStringBuilder.optElement("name", item.getName());
        xmlStringBuilder.optElement("type", item.getItemType());
        xmlStringBuilder.optElement("status", item.getItemStatus());
        for (String string : item.getGroupNames()) {
            xmlStringBuilder.openElement("group");
            xmlStringBuilder.element("groupName", string);
            xmlStringBuilder.closeElement("group");
        }
        xmlStringBuilder.closeElement("item");
        return FileUtils.writeFile(this.getBareJidFile(item.getUser()), xmlStringBuilder.toString());
    }

    private File getBareJidFile(String string) {
        String string2 = Base32Encoder.getInstance().encode(string);
        return new File(this.fileDir, ENTRY_PREFIX + string2);
    }

    private void log(String string) {
        System.err.println(string);
    }
}

