/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Random;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
extends AbstractConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(ReconnectionManager.class.getName());
    private XMPPConnection connection;
    private Thread reconnectionThread;
    private int randomBase = new Random().nextInt(11) + 5;
    boolean done = false;

    private ReconnectionManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.getConfiguration().isReconnectionAllowed();
    }

    protected synchronized void reconnect() {
        if (this.isReconnectionAllowed()) {
            if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
                return;
            }
            this.reconnectionThread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    ++this.attempts;
                    if (this.attempts > 13) {
                        return ReconnectionManager.this.randomBase * 6 * 5;
                    }
                    if (this.attempts > 7) {
                        return ReconnectionManager.this.randomBase * 6;
                    }
                    return ReconnectionManager.this.randomBase;
                }

                @Override
                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int n = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && n > 0) {
                            try {
                                Thread.sleep(1000L);
                                ReconnectionManager.this.notifyAttemptToReconnectIn(--n);
                            }
                            catch (InterruptedException interruptedException) {
                                LOGGER.warning("Sleeping thread interrupted");
                                ReconnectionManager.this.notifyReconnectionFailed(interruptedException);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (Exception exception) {
                            ReconnectionManager.this.notifyReconnectionFailed(exception);
                        }
                    }
                }
            };
            this.reconnectionThread.setName("Smack Reconnection Manager");
            this.reconnectionThread.setDaemon(true);
            this.reconnectionThread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener connectionListener : this.connection.connectionListeners) {
                connectionListener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int n) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener connectionListener : this.connection.connectionListeners) {
                connectionListener.reconnectingIn(n);
            }
        }
    }

    @Override
    public void connectionClosed() {
        this.done = true;
    }

    @Override
    public void connectionClosedOnError(Exception exception) {
        XMPPException.StreamErrorException streamErrorException;
        StreamError streamError;
        String string;
        this.done = false;
        if (exception instanceof XMPPException.StreamErrorException && "conflict".equals(string = (streamError = (streamErrorException = (XMPPException.StreamErrorException)exception).getStreamError()).getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                xMPPConnection.addConnectionListener(new ReconnectionManager(xMPPConnection));
            }
        });
    }
}

