/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class RosterGroup {
    private String name;
    private XMPPConnection connection;
    private final Set<RosterEntry> entries;

    RosterGroup(String string, XMPPConnection xMPPConnection) {
        this.name = string;
        this.connection = xMPPConnection;
        this.entries = new LinkedHashSet<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws SmackException.NotConnectedException {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.name);
                item.addGroupName(string);
                rosterPacket.addRosterItem(item);
                this.connection.sendPacket(rosterPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RosterEntry> getEntries() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<RosterEntry>(this.entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(String string) {
        if (string == null) {
            return null;
        }
        string = StringUtils.parseBareAddress(string);
        String string2 = string.toLowerCase(Locale.US);
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                if (!rosterEntry.getUser().equals(string2)) continue;
                return rosterEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.contains(rosterEntry);
        }
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry rosterEntry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PacketCollector packetCollector = null;
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (!this.entries.contains(rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.addGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                packetCollector = this.connection.createPacketCollectorAndSend(rosterPacket);
            }
        }
        if (packetCollector != null) {
            packetCollector.nextResultOrThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry rosterEntry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PacketCollector packetCollector = null;
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains(rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                packetCollector = this.connection.createPacketCollectorAndSend(rosterPacket);
            }
        }
        if (packetCollector != null) {
            packetCollector.nextResultOrThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            this.entries.remove(rosterEntry);
            this.entries.add(rosterEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains(rosterEntry)) {
                this.entries.remove(rosterEntry);
            }
        }
    }
}

