/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLDigestMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLExternalMechanism;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.SASLPlainMechanism;

public class SASLAuthentication {
    private static Map<String, Class<? extends SASLMechanism>> implementedMechanisms = new HashMap<String, Class<? extends SASLMechanism>>();
    private static List<String> mechanismsPreferences = new ArrayList<String>();
    private XMPPConnection connection;
    private Collection<String> serverMechanisms = new ArrayList<String>();
    private SASLMechanism currentMechanism = null;
    private boolean saslNegotiated;
    private SASLMechanism.SASLFailure saslFailure;

    public static void registerSASLMechanism(String string, Class<? extends SASLMechanism> clazz) {
        implementedMechanisms.put(string, clazz);
    }

    public static void unregisterSASLMechanism(String string) {
        implementedMechanisms.remove(string);
        mechanismsPreferences.remove(string);
    }

    public static void supportSASLMechanism(String string) {
        mechanismsPreferences.add(0, string);
    }

    public static void supportSASLMechanism(String string, int n) {
        mechanismsPreferences.add(n, string);
    }

    public static void unsupportSASLMechanism(String string) {
        mechanismsPreferences.remove(string);
    }

    public static List<Class<? extends SASLMechanism>> getRegisterSASLMechanisms() {
        ArrayList<Class<? extends SASLMechanism>> arrayList = new ArrayList<Class<? extends SASLMechanism>>();
        for (String string : mechanismsPreferences) {
            arrayList.add(implementedMechanisms.get(string));
        }
        return arrayList;
    }

    SASLAuthentication(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        return !this.serverMechanisms.isEmpty() && (this.serverMechanisms.size() != 1 || !this.hasAnonymousAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String string, CallbackHandler callbackHandler) throws IOException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SASLErrorException, SmackException.ResourceBindingNotOfferedException, SmackException.NotConnectedException {
        String string2 = null;
        for (String object : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(object) || !this.serverMechanisms.contains(object)) continue;
            string2 = object;
            break;
        }
        if (string2 != null) {
            Class<? extends SASLMechanism> clazz = implementedMechanisms.get(string2);
            try {
                Constructor constructor = clazz.getConstructor(SASLAuthentication.class);
                this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
            }
            catch (Exception sASLAuthentication) {
                throw new SaslException("Exception when creating the SASLAuthentication instance", sASLAuthentication);
            }
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                this.currentMechanism.authenticate(this.connection.getHost(), callbackHandler);
                try {
                    this.wait(this.connection.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.saslFailure != null) {
                throw new SASLErrorException(string2, this.saslFailure);
            }
            if (!this.saslNegotiated) {
                throw new SmackException.NoResponseException();
            }
        } else {
            throw new SaslException("SASL Authentication failed. No known authentication mechanisims.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String string, String string2, String string3) throws XMPPException.XMPPErrorException, SASLErrorException, SaslException, IOException, SmackException {
        String string4 = null;
        for (String object : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(object) || !this.serverMechanisms.contains(object)) continue;
            string4 = object;
            break;
        }
        if (string4 != null) {
            Class<? extends SASLMechanism> clazz = implementedMechanisms.get(string4);
            try {
                Constructor exception = clazz.getConstructor(SASLAuthentication.class);
                this.currentMechanism = (SASLMechanism)exception.newInstance(this);
            }
            catch (Exception exception) {
                throw new SaslException("Exception when creating the SASLAuthentication instance", exception);
            }
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                String string5 = this.connection.getServiceName();
                this.currentMechanism.authenticate(string, this.connection.getHost(), string5, string2);
                try {
                    this.wait(this.connection.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.saslFailure != null) {
                throw new SASLErrorException(string4, this.saslFailure);
            }
            if (!this.saslNegotiated) {
                throw new SmackException.NoResponseException();
            }
        } else {
            throw new SaslException("SASL Authentication failed. No known authentication mechanisims.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticateAnonymously() throws SASLErrorException, SaslException, IOException, SmackException, XMPPException.XMPPErrorException {
        this.currentMechanism = new SASLAnonymous(this);
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.authenticate(null, null, null, "");
            try {
                this.wait(this.connection.getPacketReplyTimeout());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.saslFailure != null) {
            throw new SASLErrorException(this.currentMechanism.toString(), this.saslFailure);
        }
        if (!this.saslNegotiated) {
            throw new SmackException.NoResponseException();
        }
    }

    public void setAvailableSASLMethods(Collection<String> collection) {
        this.serverMechanisms = collection;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    public void challengeReceived(String string) throws IOException, SmackException.NotConnectedException {
        this.currentMechanism.challengeReceived(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticated() {
        this.saslNegotiated = true;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticationFailed(SASLMechanism.SASLFailure sASLFailure) {
        this.saslFailure = sASLFailure;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    public void send(Packet packet) throws SmackException.NotConnectedException {
        this.connection.sendPacket(packet);
    }

    protected void init() {
        this.saslNegotiated = false;
        this.saslFailure = null;
    }

    static {
        SASLAuthentication.registerSASLMechanism("EXTERNAL", SASLExternalMechanism.class);
        SASLAuthentication.registerSASLMechanism("DIGEST-MD5", SASLDigestMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("PLAIN", SASLPlainMechanism.class);
        SASLAuthentication.registerSASLMechanism("ANONYMOUS", SASLAnonymous.class);
        SASLAuthentication.supportSASLMechanism("DIGEST-MD5", 0);
        SASLAuthentication.supportSASLMechanism("PLAIN", 1);
        SASLAuthentication.supportSASLMechanism("ANONYMOUS", 2);
    }
}

