/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class AndFilter
implements PacketFilter {
    private final List<PacketFilter> filters;

    public AndFilter() {
        this.filters = new ArrayList<PacketFilter>();
    }

    public AndFilter(PacketFilter ... packetFilterArray) {
        if (packetFilterArray == null) {
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        for (PacketFilter packetFilter : packetFilterArray) {
            if (packetFilter != null) continue;
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        this.filters = new ArrayList<PacketFilter>(Arrays.asList(packetFilterArray));
    }

    public void addFilter(PacketFilter packetFilter) {
        if (packetFilter == null) {
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        this.filters.add(packetFilter);
    }

    @Override
    public boolean accept(Packet packet) {
        for (PacketFilter packetFilter : this.filters) {
            if (packetFilter.accept(packet)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.filters.toString();
    }
}

