/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class Packet {
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private static String DEFAULT_XML_NS = null;
    public static final String ID_NOT_AVAILABLE = "ID_NOT_AVAILABLE";
    private static String prefix = StringUtils.randomString(5) + "-";
    private static long id = 0L;
    private String xmlns = DEFAULT_XML_NS;
    private String packetID = null;
    private String to = null;
    private String from = null;
    private final List<PacketExtension> packetExtensions = new CopyOnWriteArrayList<PacketExtension>();
    private XMPPError error = null;

    public static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    public static void setDefaultXmlns(String string) {
        DEFAULT_XML_NS = string;
    }

    public Packet() {
    }

    public Packet(Packet packet) {
        this.packetID = packet.getPacketID();
        this.to = packet.getTo();
        this.from = packet.getFrom();
        this.xmlns = packet.xmlns;
        this.error = packet.error;
        for (PacketExtension packetExtension : packet.getExtensions()) {
            this.addExtension(packetExtension);
        }
    }

    public String getPacketID() {
        if (ID_NOT_AVAILABLE.equals(this.packetID)) {
            return null;
        }
        if (this.packetID == null) {
            this.packetID = Packet.nextID();
        }
        return this.packetID;
    }

    public void setPacketID(String string) {
        this.packetID = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError xMPPError) {
        this.error = xMPPError;
    }

    public synchronized Collection<PacketExtension> getExtensions() {
        if (this.packetExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<PacketExtension>(this.packetExtensions));
    }

    public PacketExtension getExtension(String string) {
        return this.getExtension(null, string);
    }

    public <PE extends PacketExtension> PE getExtension(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        for (PacketExtension packetExtension : this.packetExtensions) {
            if (string != null && !string.equals(packetExtension.getElementName()) || !string2.equals(packetExtension.getNamespace())) continue;
            return (PE)packetExtension;
        }
        return null;
    }

    public void addExtension(PacketExtension packetExtension) {
        if (packetExtension == null) {
            return;
        }
        this.packetExtensions.add(packetExtension);
    }

    public void addExtensions(Collection<PacketExtension> collection) {
        if (collection == null) {
            return;
        }
        this.packetExtensions.addAll(collection);
    }

    public void removeExtension(PacketExtension packetExtension) {
        this.packetExtensions.remove(packetExtension);
    }

    public abstract CharSequence toXML();

    protected synchronized CharSequence getExtensionsXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        for (PacketExtension packetExtension : this.getExtensions()) {
            xmlStringBuilder.append(packetExtension.toXML());
        }
        return xmlStringBuilder;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Packet packet = (Packet)object;
        if (this.error != null ? !this.error.equals(packet.error) : packet.error != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(packet.from) : packet.from != null) {
            return false;
        }
        if (!this.packetExtensions.equals(packet.packetExtensions)) {
            return false;
        }
        if (this.packetID != null ? !this.packetID.equals(packet.packetID) : packet.packetID != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(packet.to) : packet.to != null) {
            return false;
        }
        return !(this.xmlns == null ? packet.xmlns != null : !this.xmlns.equals(packet.xmlns));
    }

    public int hashCode() {
        int n = this.xmlns != null ? this.xmlns.hashCode() : 0;
        n = 31 * n + (this.packetID != null ? this.packetID.hashCode() : 0);
        n = 31 * n + (this.to != null ? this.to.hashCode() : 0);
        n = 31 * n + (this.from != null ? this.from.hashCode() : 0);
        n = 31 * n + this.packetExtensions.hashCode();
        n = 31 * n + (this.error != null ? this.error.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.toXML().toString();
    }

    protected void addCommonAttributes(XmlStringBuilder xmlStringBuilder) {
        xmlStringBuilder.optAttribute("id", this.getPacketID());
        xmlStringBuilder.optAttribute("to", this.getTo());
        xmlStringBuilder.optAttribute("from", this.getFrom());
    }
}

