/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class Presence
extends Packet {
    private Type type = Type.available;
    private String status = null;
    private int priority = Integer.MIN_VALUE;
    private Mode mode = null;
    private String language;

    public Presence(Type type) {
        this.setType(type);
    }

    public Presence(Type type, String string, int n, Mode mode) {
        this.setType(type);
        this.setStatus(string);
        this.setPriority(n);
        this.setMode(mode);
    }

    public boolean isAvailable() {
        return this.type == Type.available;
    }

    public boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        if (n < -128 || n > 128) {
            throw new IllegalArgumentException("Priority value " + n + " is not valid. Valid range is -128 through 128.");
        }
        this.priority = n;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement("presence");
        xmlStringBuilder.xmlnsAttribute(this.getXmlns());
        xmlStringBuilder.xmllangAttribute(this.getLanguage());
        this.addCommonAttributes(xmlStringBuilder);
        if (this.type != Type.available) {
            xmlStringBuilder.attribute("type", this.type);
        }
        xmlStringBuilder.rightAngelBracket();
        xmlStringBuilder.optElement("status", this.status);
        if (this.priority != Integer.MIN_VALUE) {
            xmlStringBuilder.element("priority", Integer.toString(this.priority));
        }
        if (this.mode != null && this.mode != Mode.available) {
            xmlStringBuilder.element("show", this.mode);
        }
        xmlStringBuilder.append(this.getExtensionsXML());
        XMPPError xMPPError = this.getError();
        if (xMPPError != null) {
            xmlStringBuilder.append(xMPPError.toXML());
        }
        xmlStringBuilder.closeElement("presence");
        return xmlStringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.type);
        if (this.mode != null) {
            stringBuilder.append(": ").append((Object)this.mode);
        }
        if (this.getStatus() != null) {
            stringBuilder.append(" (").append(this.getStatus()).append(")");
        }
        return stringBuilder.toString();
    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;

    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error;

    }
}

