/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProviderFileLoader.class.getName());
    private Collection<IQProviderInfo> iqProviders;
    private Collection<ExtensionProviderInfo> extProviders;
    private List<Exception> exceptions = new LinkedList<Exception>();

    public ProviderFileLoader(InputStream inputStream) {
        this(inputStream, ProviderFileLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderFileLoader(InputStream inputStream, ClassLoader classLoader) {
        this.iqProviders = new ArrayList<IQProviderInfo>();
        this.extProviders = new ArrayList<ExtensionProviderInfo>();
        try {
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput(inputStream, "UTF-8");
            int n = xmlPullParser.getEventType();
            do {
                if (n != 2) continue;
                String string = xmlPullParser.getName();
                try {
                    if ("smackProviders".equals(string)) continue;
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string2 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string3 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    String string4 = xmlPullParser.nextText();
                    try {
                        Class<?> clazz = classLoader.loadClass(string4);
                        if ("iqProvider".equals(string)) {
                            if (IQProvider.class.isAssignableFrom(clazz)) {
                                this.iqProviders.add(new IQProviderInfo(string2, string3, (IQProvider)clazz.newInstance()));
                                continue;
                            }
                            if (!IQ.class.isAssignableFrom(clazz)) continue;
                            this.iqProviders.add(new IQProviderInfo(string2, string3, clazz));
                            continue;
                        }
                        if (PacketExtensionProvider.class.isAssignableFrom(clazz)) {
                            this.extProviders.add(new ExtensionProviderInfo(string2, string3, (PacketExtensionProvider)clazz.newInstance()));
                            continue;
                        }
                        if (!PacketExtension.class.isAssignableFrom(clazz)) continue;
                        this.extProviders.add(new ExtensionProviderInfo(string2, string3, clazz));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.log(Level.SEVERE, "Could not find provider class", classNotFoundException);
                        this.exceptions.add(classNotFoundException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.SEVERE, "Invalid provider type found [" + string + "] when expecting iqProvider or extensionProvider", illegalArgumentException);
                    this.exceptions.add(illegalArgumentException);
                }
            } while ((n = xmlPullParser.next()) != 1);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Unknown error occurred while parsing provider file", exception);
            this.exceptions.add(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        return this.extProviders;
    }

    public List<Exception> getLoadingExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

