/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;

public final class ProviderManager {
    private static final Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    public static void addLoader(ProviderLoader providerLoader) {
        if (providerLoader.getIQProviderInfo() != null) {
            for (IQProviderInfo abstractProviderInfo : providerLoader.getIQProviderInfo()) {
                iqProviders.put(ProviderManager.getProviderKey(abstractProviderInfo.getElementName(), abstractProviderInfo.getNamespace()), abstractProviderInfo.getProvider());
            }
        }
        if (providerLoader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : providerLoader.getExtensionProviderInfo()) {
                extensionProviders.put(ProviderManager.getProviderKey(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace()), extensionProviderInfo.getProvider());
            }
        }
    }

    public static Object getIQProvider(String string, String string2) {
        String string3 = ProviderManager.getProviderKey(string, string2);
        return iqProviders.get(string3);
    }

    public static Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(iqProviders.values());
    }

    public static void addIQProvider(String string, String string2, Object object) {
        if (!(object instanceof IQProvider || object instanceof Class && IQ.class.isAssignableFrom((Class)object))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance sublcassing IQ.");
        }
        String string3 = ProviderManager.getProviderKey(string, string2);
        iqProviders.put(string3, object);
    }

    public static void removeIQProvider(String string, String string2) {
        String string3 = ProviderManager.getProviderKey(string, string2);
        iqProviders.remove(string3);
    }

    public static Object getExtensionProvider(String string, String string2) {
        String string3 = ProviderManager.getProviderKey(string, string2);
        return extensionProviders.get(string3);
    }

    public static void addExtensionProvider(String string, String string2, Object object) {
        if (!(object instanceof PacketExtensionProvider) && !(object instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String string3 = ProviderManager.getProviderKey(string, string2);
        extensionProviders.put(string3, object);
    }

    public static void removeExtensionProvider(String string, String string2) {
        String string3 = ProviderManager.getProviderKey(string, string2);
        extensionProviders.remove(string3);
    }

    public static Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(extensionProviders.values());
    }

    private static String getProviderKey(String string, String string2) {
        return string + '#' + string2;
    }
}

