/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import de.measite.smack.Sasl;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.TextInputCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.RealmCallback;
import org.apache.harmony.javax.security.sasl.RealmChoiceCallback;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class SASLMechanism
implements CallbackHandler {
    private SASLAuthentication saslAuthentication;
    protected SaslClient sc;
    protected String authenticationId;
    protected String password;
    protected String hostname;

    public SASLMechanism(SASLAuthentication sASLAuthentication) {
        this.saslAuthentication = sASLAuthentication;
    }

    public void authenticate(String string, String string2, String string3, String string4) throws IOException, SaslException, SmackException.NotConnectedException {
        this.authenticationId = string;
        this.password = string4;
        this.hostname = string2;
        String[] stringArray = new String[]{this.getName()};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray, null, "xmpp", string3, hashMap, this);
        this.authenticate();
    }

    public void authenticate(String string, CallbackHandler callbackHandler) throws IOException, SaslException, SmackException.NotConnectedException {
        String[] stringArray = new String[]{this.getName()};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray, null, "xmpp", string, hashMap, callbackHandler);
        this.authenticate();
    }

    protected void authenticate() throws IOException, SaslException, SmackException.NotConnectedException {
        String string = null;
        if (this.sc.hasInitialResponse()) {
            byte[] byArray = this.sc.evaluateChallenge(new byte[0]);
            string = StringUtils.encodeBase64(byArray, false);
        }
        this.getSASLAuthentication().send(new AuthMechanism(this.getName(), string));
    }

    public void challengeReceived(String string) throws IOException, SmackException.NotConnectedException {
        byte[] byArray = string != null ? this.sc.evaluateChallenge(StringUtils.decodeBase64(string)) : this.sc.evaluateChallenge(new byte[0]);
        Response response = byArray == null ? new Response() : new Response(StringUtils.encodeBase64(byArray, false));
        this.getSASLAuthentication().send(response);
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Serializable serializable;
            if (callbackArray[i] instanceof NameCallback) {
                serializable = (NameCallback)callbackArray[i];
                ((NameCallback)serializable).setName(this.authenticationId);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                serializable = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)serializable).setPassword(this.password.toCharArray());
                continue;
            }
            if (callbackArray[i] instanceof RealmCallback) {
                serializable = (RealmCallback)callbackArray[i];
                String string = ((TextInputCallback)serializable).getDefaultText();
                ((TextInputCallback)serializable).setText(string);
                continue;
            }
            if (callbackArray[i] instanceof RealmChoiceCallback) continue;
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    public static class SASLFailure
    extends Packet {
        private final SASLError saslError;
        private final String saslErrorString;

        public SASLFailure(String string) {
            SASLError sASLError = SASLError.fromString(string);
            this.saslError = sASLError == null ? SASLError.not_authorized : sASLError;
            this.saslErrorString = string;
        }

        public SASLError getSASLError() {
            return this.saslError;
        }

        public String getSASLErrorString() {
            return this.saslErrorString;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<failure xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            stringBuilder.append("<").append(this.saslErrorString).append("/>");
            stringBuilder.append("</failure>");
            return stringBuilder.toString();
        }
    }

    public static class Success
    extends Packet {
        private final String data;

        public Success(String string) {
            this.data = string;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<success xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.data != null && this.data.trim().length() > 0) {
                stringBuilder.append(this.data);
            }
            stringBuilder.append("</success>");
            return stringBuilder.toString();
        }
    }

    public static class Response
    extends Packet {
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String string) {
            this.authenticationText = string == null || string.trim().length() == 0 ? null : string;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null) {
                stringBuilder.append(this.authenticationText);
            }
            stringBuilder.append("</response>");
            return stringBuilder.toString();
        }
    }

    public static class Challenge
    extends Packet {
        private final String data;

        public Challenge(String string) {
            this.data = string;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<challenge xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.data != null && this.data.trim().length() > 0) {
                stringBuilder.append(this.data);
            }
            stringBuilder.append("</challenge>");
            return stringBuilder.toString();
        }
    }

    public static class AuthMechanism
    extends Packet {
        private final String name;
        private final String authenticationText;

        public AuthMechanism(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("SASL mechanism name shouldn't be null.");
            }
            this.name = string;
            this.authenticationText = string2;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<auth mechanism=\"").append(this.name);
            stringBuilder.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null && this.authenticationText.trim().length() > 0) {
                stringBuilder.append(this.authenticationText);
            }
            stringBuilder.append("</auth>");
            return stringBuilder.toString();
        }
    }
}

