/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;

class PacketWriter {
    public static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(PacketWriter.class.getName());
    private final XMPPTCPConnection connection;
    private final ArrayBlockingQueueWithShutdown<Packet> queue = new ArrayBlockingQueueWithShutdown(500, true);
    private Thread writerThread;
    private Writer writer;
    volatile boolean done;
    AtomicBoolean shutdownDone = new AtomicBoolean(false);

    protected PacketWriter(XMPPTCPConnection xMPPTCPConnection) {
        this.connection = xMPPTCPConnection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.getWriter();
        this.done = false;
        this.shutdownDone.set(false);
        this.queue.start();
        this.writerThread = new Thread(){

            @Override
            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.getConnectionCounter() + ")");
        this.writerThread.setDaemon(true);
    }

    public void sendPacket(Packet packet) throws SmackException.NotConnectedException {
        if (this.done) {
            throw new SmackException.NotConnectedException();
        }
        try {
            this.queue.put(packet);
        }
        catch (InterruptedException interruptedException) {
            throw new SmackException.NotConnectedException();
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        this.queue.shutdown();
        AtomicBoolean atomicBoolean = this.shutdownDone;
        synchronized (atomicBoolean) {
            if (!this.shutdownDone.get()) {
                try {
                    this.shutdownDone.wait(this.connection.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.WARNING, "shutdown", interruptedException);
                }
            }
        }
    }

    private Packet nextPacket() {
        if (this.done) {
            return null;
        }
        Packet packet = null;
        try {
            packet = this.queue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackets(Thread thread) {
        block21: {
            try {
                Object object;
                this.openStream();
                while (!this.done && this.writerThread == thread) {
                    object = this.nextPacket();
                    if (object == null) continue;
                    this.writer.write(((Packet)object).toXML().toString());
                    if (!this.queue.isEmpty()) continue;
                    this.writer.flush();
                }
                try {
                    while (!this.queue.isEmpty()) {
                        object = (Packet)this.queue.remove();
                        this.writer.write(((Packet)object).toXML().toString());
                    }
                    this.writer.flush();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", exception);
                }
                this.queue.clear();
                try {
                    this.writer.write("</stream:stream>");
                    this.writer.flush();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Exception writing closing stream element", exception);
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception exception) {}
                }
                this.shutdownDone.set(true);
                object = this.shutdownDone;
                synchronized (object) {
                    this.shutdownDone.notify();
                }
            }
            catch (IOException iOException) {
                if (this.done || this.connection.isSocketClosed()) break block21;
                this.shutdown();
                this.connection.notifyConnectionError(iOException);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stream:stream");
        stringBuilder.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stringBuilder.append(" xmlns=\"jabber:client\"");
        stringBuilder.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stringBuilder.append(" version=\"1.0\">");
        this.writer.write(stringBuilder.toString());
        this.writer.flush();
    }
}

