/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.tcp.PacketReader;
import org.jivesoftware.smack.tcp.PacketWriter;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class XMPPTCPConnection
extends XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    Socket socket;
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private volatile boolean socketClosed = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    PacketWriter packetWriter;
    PacketReader packetReader;
    private Collection<String> compressionMethods;
    private boolean serverAckdCompression = false;
    private final Object compressionLock = new Object();

    public XMPPTCPConnection(String string, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(string));
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPTCPConnection(String string) {
        super(new ConnectionConfiguration(string));
    }

    public XMPPTCPConnection(ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
    }

    public XMPPTCPConnection(ConnectionConfiguration connectionConfiguration, CallbackHandler callbackHandler) {
        super(connectionConfiguration);
        connectionConfiguration.setCallbackHandler(callbackHandler);
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        this.parsingExceptionCallback = parsingExceptionCallback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    @Override
    public synchronized void login(String string, String string2, String string3) throws XMPPException, SmackException, SaslException, IOException {
        String string4;
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        string = string.toLowerCase(Locale.US).trim();
        if (this.saslAuthentication.hasNonAnonymousAuthentication()) {
            if (string2 != null) {
                this.saslAuthentication.authenticate(string, string2, string3);
            } else {
                this.saslAuthentication.authenticate(string3, this.config.getCallbackHandler());
            }
        } else {
            throw new SaslException("No non-anonymous SASL authentication mechanism available");
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        if ((string4 = this.bindResourceAndEstablishSession(string3)) != null) {
            this.user = string4;
            this.setServiceName(StringUtils.parseServer(string4));
        } else {
            this.user = string + "@" + this.getServiceName();
            if (string3 != null) {
                this.user = this.user + "/" + string3;
            }
        }
        this.authenticated = true;
        this.anonymous = false;
        this.setLoginInfo(string, string2, string3);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
        if (this.config.isSendPresence()) {
            this.sendPacket(new Presence(Presence.Type.available));
        }
    }

    @Override
    public synchronized void loginAnonymously() throws XMPPException, SmackException, SaslException, IOException {
        String string;
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        if (!this.saslAuthentication.hasAnonymousAuthentication()) {
            throw new SaslException("No anonymous SASL authentication mechanism available");
        }
        this.saslAuthentication.authenticateAnonymously();
        this.user = string = this.bindResourceAndEstablishSession(null);
        this.setServiceName(StringUtils.parseServer(string));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    protected void shutdown() {
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "shutdown", exception);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        this.usingTLS = false;
        this.reader = null;
        this.writer = null;
    }

    @Override
    protected void sendPacketInternal(Packet packet) throws SmackException.NotConnectedException {
        this.packetWriter.sendPacket(packet);
    }

    private void connectUsingConfiguration(ConnectionConfiguration connectionConfiguration) throws SmackException, IOException {
        Exception exception = null;
        try {
            this.maybeResolveDns();
        }
        catch (Exception exception2) {
            throw new SmackException(exception2);
        }
        Iterator<HostAddress> iterator = connectionConfiguration.getHostAddresses().iterator();
        LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>();
        while (iterator.hasNext()) {
            exception = null;
            HostAddress hostAddress = iterator.next();
            String string = hostAddress.getFQDN();
            int n = hostAddress.getPort();
            try {
                this.socket = connectionConfiguration.getSocketFactory() == null ? new Socket(string, n) : connectionConfiguration.getSocketFactory().createSocket(string, n);
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            if (exception == null) {
                string = hostAddress.getFQDN();
                n = hostAddress.getPort();
                break;
            }
            hostAddress.setException(exception);
            linkedList.add(hostAddress);
            if (iterator.hasNext()) continue;
            throw new SmackException.ConnectionException(linkedList);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws SmackException, IOException {
        boolean bl = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.serverAckdCompression = false;
        this.initReaderAndWriter();
        try {
            if (bl) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            if (bl) {
                for (ConnectionCreationListener connectionCreationListener : XMPPTCPConnection.getConnectionCreationListeners()) {
                    connectionCreationListener.connectionCreated(this);
                }
            }
        }
        catch (SmackException smackException) {
            this.shutdown();
            throw smackException;
        }
    }

    private void initReaderAndWriter() throws IOException {
        try {
            if (this.compressionHandler == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    OutputStream outputStream = this.compressionHandler.getOutputStream(this.socket.getOutputStream());
                    this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                    InputStream inputStream = this.compressionHandler.getInputStream(this.socket.getInputStream());
                    this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "initReaderAndWriter()", exception);
                    this.compressionHandler = null;
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        this.initDebugger();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    void startTLSReceived(boolean bl) throws IOException {
        if (bl && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
        this.writer.flush();
    }

    void proceedTLSReceived() throws Exception {
        Object object;
        Object object2;
        Constructor<?> constructor;
        SSLContext sSLContext = this.config.getCustomSSLContext();
        KeyStore keyStore = null;
        KeyManager[] keyManagerArray = null;
        PasswordCallback passwordCallback = null;
        if (this.config.getCallbackHandler() == null) {
            keyStore = null;
        } else if (sSLContext == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                keyStore = null;
                passwordCallback = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    constructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    object2 = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    object = new ByteArrayInputStream(((String)object2).getBytes());
                    Provider provider = (Provider)constructor.newInstance(object);
                    Security.addProvider(provider);
                    keyStore = KeyStore.getInstance("PKCS11", provider);
                    passwordCallback = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(null, passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                keyStore = KeyStore.getInstance("KeychainStore", "Apple");
                keyStore.load(null, null);
            } else {
                keyStore = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    passwordCallback = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(new FileInputStream(this.config.getKeystorePath()), passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            }
            constructor = KeyManagerFactory.getInstance("SunX509");
            try {
                if (passwordCallback == null) {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, null);
                } else {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
                keyManagerArray = ((KeyManagerFactory)((Object)constructor)).getKeyManagers();
            }
            catch (NullPointerException nullPointerException) {
                keyManagerArray = null;
            }
        }
        if (sSLContext == null) {
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, null, new SecureRandom());
        }
        constructor = this.socket;
        this.socket = sSLContext.getSocketFactory().createSocket((Socket)((Object)constructor), ((Socket)((Object)constructor)).getInetAddress().getHostAddress(), ((Socket)((Object)constructor)).getPort(), true);
        this.initReaderAndWriter();
        object2 = (SSLSocket)this.socket;
        try {
            ((SSLSocket)object2).startHandshake();
        }
        catch (IOException iOException) {
            this.setConnectionException(iOException);
            throw iOException;
        }
        object = this.getConfiguration().getHostnameVerifier();
        if (object != null && !object.verify(this.getServiceName(), ((SSLSocket)object2).getSession())) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + this.getServiceName());
        }
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection<String> collection) {
        this.compressionMethods = collection;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        if (this.compressionMethods != null) {
            for (XMPPInputOutputStream xMPPInputOutputStream : SmackConfiguration.getCompresionHandlers()) {
                String string = xMPPInputOutputStream.getCompressionMethod();
                if (!this.compressionMethods.contains(string)) continue;
                return xMPPInputOutputStream;
            }
        }
        return null;
    }

    @Override
    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.serverAckdCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() throws IOException {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            Object object = this.compressionLock;
            synchronized (object) {
                this.requestStreamCompression(this.compressionHandler.getCompressionMethod());
                try {
                    this.compressionLock.wait(this.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isUsingCompression();
        }
        return false;
    }

    private void requestStreamCompression(String string) throws IOException {
        this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
        this.writer.write("<method>" + string + "</method></compress>");
        this.writer.flush();
    }

    void startStreamCompression() throws IOException {
        this.serverAckdCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        this.streamCompressionNegotiationDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionNegotiationDone() {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionLock.notify();
        }
    }

    @Override
    protected void connectInternal() throws SmackException, IOException, XMPPException {
        this.connectUsingConfiguration(this.config);
        if (this.connected) {
            this.callConnectionConnectedListener();
        }
        if (this.connected && this.wasAuthenticated) {
            if (this.isAnonymous()) {
                this.loginAnonymously();
            } else {
                this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
            }
            this.notifyReconnection();
        }
    }

    synchronized void notifyConnectionError(Exception exception) {
        if ((this.packetReader == null || this.packetReader.done) && (this.packetWriter == null || this.packetWriter.done)) {
            return;
        }
        this.shutdown();
        this.callConnectionClosedOnErrorListener(exception);
    }

    @Override
    protected void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    @Override
    protected Reader getReader() {
        return super.getReader();
    }

    @Override
    protected Writer getWriter() {
        return super.getWriter();
    }

    @Override
    protected void throwConnectionExceptionOrNoResponse() throws IOException, SmackException.NoResponseException {
        super.throwConnectionExceptionOrNoResponse();
    }

    @Override
    protected void setServiceName(String string) {
        super.setServiceName(string);
    }

    @Override
    protected void serverRequiresBinding() {
        super.serverRequiresBinding();
    }

    @Override
    protected void setServiceCapsNode(String string) {
        super.setServiceCapsNode(string);
    }

    @Override
    protected void serverSupportsSession() {
        super.serverSupportsSession();
    }

    @Override
    protected void setRosterVersioningSupported() {
        super.setRosterVersioningSupported();
    }

    @Override
    protected void serverSupportsAccountCreation() {
        super.serverSupportsAccountCreation();
    }

    @Override
    protected SASLAuthentication getSASLAuthentication() {
        return super.getSASLAuthentication();
    }

    @Override
    protected ConnectionConfiguration getConfiguration() {
        return super.getConfiguration();
    }

    private void notifyReconnection() {
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            try {
                connectionListener.reconnectionSuccessful();
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "notifyReconnection()", exception);
            }
        }
    }
}

