/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static InputStream getStreamForUrl(String string, ClassLoader classLoader) throws MalformedURLException, IOException {
        URI uRI = URI.create(string);
        if (uRI.getScheme() == null) {
            throw new MalformedURLException("No protocol found in file URL: " + string);
        }
        if (uRI.getScheme().equals("classpath")) {
            List<ClassLoader> list = FileUtils.getClassLoaders();
            if (classLoader != null) {
                list.add(0, classLoader);
            }
            for (ClassLoader classLoader2 : list) {
                InputStream inputStream = classLoader2.getResourceAsStream(uRI.getSchemeSpecificPart());
                if (inputStream == null) continue;
                return inputStream;
            }
        } else {
            return uRI.toURL().openStream();
        }
        return null;
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{FileUtils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(classLoaderArray.length);
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList;
    }

    public static boolean addLines(String string, Set<String> set) throws MalformedURLException, IOException {
        String string2;
        InputStream inputStream = FileUtils.getStreamForUrl(string, null);
        if (inputStream == null) {
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            set.add(string2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileOrThrow(File file) throws FileNotFoundException, IOException {
        try (FileReader fileReader = null;){
            int n;
            fileReader = new FileReader(file);
            char[] cArray = new char[8192];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = fileReader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFileOrThrow(file);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "readFile", exception);
            return null;
        }
    }

    public static void writeFileOrThrow(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file, false);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static boolean writeFile(File file, String string) {
        try {
            FileUtils.writeFileOrThrow(file, string);
            return true;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "writeFile", iOException);
            return false;
        }
    }
}

