/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser newXmppParser() throws XmlPullParserException {
        XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return xmlPullParser;
    }

    public static Message parseMessage(XmlPullParser xmlPullParser) throws Exception {
        Message message = new Message();
        String string = xmlPullParser.getAttributeValue("", "id");
        message.setPacketID(string == null ? "ID_NOT_AVAILABLE" : string);
        message.setTo(xmlPullParser.getAttributeValue("", "to"));
        message.setFrom(xmlPullParser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(xmlPullParser.getAttributeValue("", "type")));
        String string2 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        String string3 = null;
        if (string2 != null && !"".equals(string2.trim())) {
            message.setLanguage(string2);
            string3 = string2;
        } else {
            string3 = Packet.getDefaultLanguage();
        }
        boolean bl = false;
        String string4 = null;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string5;
                String string6;
                String string7 = xmlPullParser.getName();
                String string8 = xmlPullParser.getNamespace();
                if (string7.equals("subject")) {
                    string6 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
                    if (string6 == null) {
                        string6 = string3;
                    }
                    string5 = PacketParserUtils.parseElementText(xmlPullParser);
                    if (message.getSubject(string6) != null) continue;
                    message.addSubject(string6, string5);
                    continue;
                }
                if (string7.equals("body")) {
                    string6 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
                    if (string6 == null) {
                        string6 = string3;
                    }
                    string5 = PacketParserUtils.parseElementText(xmlPullParser);
                    if (message.getBody(string6) != null) continue;
                    message.addBody(string6, string5);
                    continue;
                }
                if (string7.equals("thread")) {
                    if (string4 != null) continue;
                    string4 = xmlPullParser.nextText();
                    continue;
                }
                if (string7.equals("error")) {
                    message.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(string7, string8, xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("message")) continue;
            bl = true;
        }
        message.setThread(string4);
        return message;
    }

    public static String parseElementText(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string;
        assert (xmlPullParser.getEventType() == 2);
        if (xmlPullParser.isEmptyElementTag()) {
            string = "";
        } else {
            int n = xmlPullParser.next();
            if (n != 4) {
                if (n == 3) {
                    return "";
                }
                throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
            }
            string = xmlPullParser.getText();
            n = xmlPullParser.next();
            if (n != 3) {
                throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
            }
        }
        return string;
    }

    public static String parseElement(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseElement(xmlPullParser, false);
    }

    public static String parseElement(XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException, IOException {
        assert (xmlPullParser.getEventType() == 2);
        return PacketParserUtils.parseContentDepth(xmlPullParser, xmlPullParser.getDepth(), bl);
    }

    public static String parseContent(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        assert (xmlPullParser.getEventType() == 2);
        if (xmlPullParser.isEmptyElementTag()) {
            return "";
        }
        xmlPullParser.next();
        return PacketParserUtils.parseContentDepth(xmlPullParser, xmlPullParser.getDepth(), false);
    }

    public static String parseContentDepth(XmlPullParser xmlPullParser, int n) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseContentDepth(xmlPullParser, n, false);
    }

    public static String parseContentDepth(XmlPullParser xmlPullParser, int n, boolean bl) throws XmlPullParserException, IOException {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        int n2 = xmlPullParser.getEventType();
        boolean bl2 = false;
        String string = null;
        while (true) {
            if (n2 == 2) {
                String string2;
                xmlStringBuilder.halfOpenElement(xmlPullParser.getName());
                if ((string == null || bl) && StringUtils.isNotEmpty(string2 = xmlPullParser.getNamespace())) {
                    xmlStringBuilder.attribute("xmlns", string2);
                    string = xmlPullParser.getName();
                }
                for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                    xmlStringBuilder.attribute(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
                }
                if (xmlPullParser.isEmptyElementTag()) {
                    xmlStringBuilder.closeEmptyElement();
                    bl2 = true;
                } else {
                    xmlStringBuilder.rightAngelBracket();
                }
            } else if (n2 == 3) {
                if (bl2) {
                    bl2 = false;
                } else {
                    xmlStringBuilder.closeElement(xmlPullParser.getName());
                }
                if (string != null && string.equals(xmlPullParser.getName())) {
                    string = null;
                }
                if (xmlPullParser.getDepth() <= n) {
                    break;
                }
            } else if (n2 == 4) {
                xmlStringBuilder.append(xmlPullParser.getText());
            }
            n2 = xmlPullParser.next();
        }
        return xmlStringBuilder.toString();
    }

    public static Presence parsePresence(XmlPullParser xmlPullParser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String string = xmlPullParser.getAttributeValue("", "type");
        if (string != null && !string.equals("")) {
            try {
                type = Presence.Type.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warning("Found invalid presence type " + string);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(xmlPullParser.getAttributeValue("", "to"));
        presence.setFrom(xmlPullParser.getAttributeValue("", "from"));
        String string2 = xmlPullParser.getAttributeValue("", "id");
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        String string3 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (string3 != null && !"".equals(string3.trim())) {
            presence.setLanguage(string3);
        }
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("status")) {
                    presence.setStatus(xmlPullParser.nextText());
                    continue;
                }
                if (string4.equals("priority")) {
                    try {
                        int n2 = Integer.parseInt(xmlPullParser.nextText());
                        presence.setPriority(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (string4.equals("show")) {
                    String string6 = xmlPullParser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(string6));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.warning("Found invalid presence mode " + string6);
                    }
                    continue;
                }
                if (string4.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                try {
                    presence.addExtension(PacketParserUtils.parsePacketExtension(string4, string5, xmlPullParser));
                }
                catch (Exception exception) {
                    LOGGER.warning("Failed to parse extension packet in Presence packet.");
                }
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("presence")) continue;
            bl = true;
        }
        return presence;
    }

    public static IQ parseIQ(XmlPullParser xmlPullParser, XMPPConnection xMPPConnection) throws Exception {
        Packet packet = null;
        XMPPError xMPPError = null;
        String string = xmlPullParser.getAttributeValue("", "id");
        String string2 = xmlPullParser.getAttributeValue("", "to");
        String string3 = xmlPullParser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("error")) {
                    xMPPError = PacketParserUtils.parseError(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:roster")) {
                    packet = PacketParserUtils.parseRoster(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:register")) {
                    packet = PacketParserUtils.parseRegistration(xmlPullParser);
                    continue;
                }
                if (string4.equals("bind") && string5.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    packet = PacketParserUtils.parseResourceBinding(xmlPullParser);
                    continue;
                }
                Object object = ProviderManager.getIQProvider(string4, string5);
                if (object != null) {
                    if (object instanceof IQProvider) {
                        packet = ((IQProvider)object).parseIQ(xmlPullParser);
                        continue;
                    }
                    if (!(object instanceof Class)) continue;
                    packet = (IQ)PacketParserUtils.parseWithIntrospection(string4, (Class)object, xmlPullParser);
                    continue;
                }
                if (IQ.Type.RESULT != type) continue;
                packet = new UnparsedResultIQ(PacketParserUtils.parseContent(xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("iq")) continue;
            bl = true;
        }
        if (packet == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                packet = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return null;
                    }
                };
                packet.setPacketID(string);
                packet.setTo(string3);
                packet.setFrom(string2);
                ((IQ)packet).setType(IQ.Type.ERROR);
                packet.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                xMPPConnection.sendPacket(packet);
                return null;
            }
            packet = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        packet.setPacketID(string);
        packet.setTo(string2);
        packet.setFrom(string3);
        ((IQ)packet).setType(type);
        packet.setError(xMPPError);
        return packet;
    }

    private static RosterPacket parseRoster(XmlPullParser xmlPullParser) throws Exception {
        RosterPacket rosterPacket = new RosterPacket();
        boolean bl = false;
        RosterPacket.Item item = null;
        String string = xmlPullParser.getAttributeValue("", "ver");
        rosterPacket.setVersion(string);
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string2;
                if (xmlPullParser.getName().equals("item")) {
                    string2 = xmlPullParser.getAttributeValue("", "jid");
                    String string3 = xmlPullParser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(string2, string3);
                    String string4 = xmlPullParser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus itemStatus = RosterPacket.ItemStatus.fromString(string4);
                    item.setItemStatus(itemStatus);
                    String string5 = xmlPullParser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType itemType = RosterPacket.ItemType.valueOf(string5 != null ? string5 : "none");
                    item.setItemType(itemType);
                    continue;
                }
                if (!xmlPullParser.getName().equals("group") || item == null || (string2 = xmlPullParser.nextText()) == null || string2.trim().length() <= 0) continue;
                item.addGroupName(string2);
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("item")) {
                rosterPacket.addRosterItem(item);
            }
            if (!xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return rosterPacket;
    }

    private static Registration parseRegistration(XmlPullParser xmlPullParser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> hashMap = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getNamespace().equals("jabber:iq:register")) {
                    String string = xmlPullParser.getName();
                    String string2 = "";
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    if (xmlPullParser.next() == 4) {
                        string2 = xmlPullParser.getText();
                    }
                    if (!string.equals("instructions")) {
                        hashMap.put(string, string2);
                        continue;
                    }
                    registration.setInstructions(string2);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        registration.setAttributes(hashMap);
        return registration;
    }

    private static Bind parseResourceBinding(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("resource")) {
                    bind.setResource(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("jid")) continue;
                bind.setJid(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("bind")) continue;
            bl = true;
        }
        return bind;
    }

    public static Collection<String> parseMechanisms(XmlPullParser xmlPullParser) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    public static Collection<String> parseCompressionMethods(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("method")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("compression")) continue;
            bl = true;
        }
        return arrayList;
    }

    public static SASLMechanism.SASLFailure parseSASLFailure(XmlPullParser xmlPullParser) throws Exception {
        String string = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("failure")) continue;
                string = xmlPullParser.getName();
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("failure")) continue;
            bl = true;
        }
        return new SASLMechanism.SASLFailure(string);
    }

    public static StreamError parseStreamError(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        String string = null;
        String string2 = null;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                String string3 = xmlPullParser.getNamespace();
                if (!"urn:ietf:params:xml:ns:xmpp-streams".equals(string3)) continue;
                String string4 = xmlPullParser.getName();
                if (string4.equals("text") && !xmlPullParser.isEmptyElementTag()) {
                    xmlPullParser.next();
                    string2 = xmlPullParser.getText();
                    continue;
                }
                string = string4;
                continue;
            }
            if (n2 != 3 || n != xmlPullParser.getDepth()) continue;
            bl = true;
        }
        return new StreamError(string, string2);
    }

    public static XMPPError parseError(XmlPullParser xmlPullParser) throws Exception {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            if (!xmlPullParser.getAttributeName(n).equals("type")) continue;
            string = xmlPullParser.getAttributeValue("", "type");
        }
        n = 0;
        while (n == 0) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("text")) {
                    string2 = xmlPullParser.nextText();
                    continue;
                }
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(string5)) {
                    string3 = string4;
                    continue;
                }
                arrayList.add(PacketParserUtils.parsePacketExtension(string4, string5, xmlPullParser));
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("error")) continue;
            n = 1;
        }
        XMPPError.Type type = XMPPError.Type.CANCEL;
        try {
            if (string != null) {
                type = XMPPError.Type.valueOf(string.toUpperCase(Locale.US));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.SEVERE, "Could not find error type for " + string.toUpperCase(Locale.US), illegalArgumentException);
        }
        return new XMPPError(type, string3, string2, arrayList);
    }

    public static PacketExtension parsePacketExtension(String string, String string2, XmlPullParser xmlPullParser) throws Exception {
        Object object = ProviderManager.getExtensionProvider(string, string2);
        if (object != null) {
            if (object instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)object).parseExtension(xmlPullParser);
            }
            if (object instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(string, (Class)object, xmlPullParser);
            }
        }
        DefaultPacketExtension defaultPacketExtension = new DefaultPacketExtension(string, string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string3 = xmlPullParser.getName();
                if (xmlPullParser.isEmptyElementTag()) {
                    defaultPacketExtension.setValue(string3, "");
                    continue;
                }
                n = xmlPullParser.next();
                if (n != 4) continue;
                String string4 = xmlPullParser.getText();
                defaultPacketExtension.setValue(string3, string4);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return defaultPacketExtension;
    }

    private static String getLanguageAttribute(XmlPullParser xmlPullParser) {
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            if (!"xml:lang".equals(string) && (!"lang".equals(string) || !"xml".equals(xmlPullParser.getAttributePrefix(i)))) continue;
            return xmlPullParser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String string, Class<?> clazz, XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        Object obj = clazz.newInstance();
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string2 = xmlPullParser.getName();
                String string3 = xmlPullParser.nextText();
                Class<?> clazz2 = obj.getClass().getMethod("get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), new Class[0]).getReturnType();
                Object object = PacketParserUtils.decode(clazz2, string3);
                obj.getClass().getMethod("set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), clazz2).invoke(obj, object);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return obj;
    }

    private static Object decode(Class<?> clazz, String string) throws Exception {
        if (clazz.getName().equals("java.lang.String")) {
            return string;
        }
        if (clazz.getName().equals("boolean")) {
            return Boolean.valueOf(string);
        }
        if (clazz.getName().equals("int")) {
            return Integer.valueOf(string);
        }
        if (clazz.getName().equals("long")) {
            return Long.valueOf(string);
        }
        if (clazz.getName().equals("float")) {
            return Float.valueOf(string);
        }
        if (clazz.getName().equals("double")) {
            return Double.valueOf(string);
        }
        if (clazz.getName().equals("java.lang.Class")) {
            return Class.forName(string);
        }
        return null;
    }

    public static class UnparsedResultIQ
    extends IQ {
        private final String str;

        public UnparsedResultIQ(String string) {
            this.str = string;
        }

        @Override
        public String getChildElementXML() {
            return this.str;
        }
    }
}

