/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.util.StringUtils;

public class XmlStringBuilder
implements Appendable,
CharSequence {
    public static final String RIGHT_ANGEL_BRACKET = Character.toString('>');
    private final LazyStringBuilder sb = new LazyStringBuilder();

    public XmlStringBuilder() {
    }

    public XmlStringBuilder(PacketExtension packetExtension) {
        this();
        this.prelude(packetExtension);
    }

    public XmlStringBuilder element(String string, String string2) {
        assert (string2 != null);
        this.openElement(string);
        this.escape(string2);
        this.closeElement(string);
        return this;
    }

    public XmlStringBuilder element(String string, Enum<?> enum_) {
        assert (enum_ != null);
        this.element(string, enum_.name());
        return this;
    }

    public XmlStringBuilder optElement(String string, String string2) {
        if (string2 != null) {
            this.element(string, string2);
        }
        return this;
    }

    public XmlStringBuilder optElement(String string, Enum<?> enum_) {
        if (enum_ != null) {
            this.element(string, enum_);
        }
        return this;
    }

    public XmlStringBuilder halfOpenElement(String string) {
        this.sb.append('<').append(string);
        return this;
    }

    public XmlStringBuilder openElement(String string) {
        this.halfOpenElement(string).rightAngelBracket();
        return this;
    }

    public XmlStringBuilder closeElement(String string) {
        this.sb.append("</").append(string);
        this.rightAngelBracket();
        return this;
    }

    public XmlStringBuilder closeElement(PacketExtension packetExtension) {
        this.closeElement(packetExtension.getElementName());
        return this;
    }

    public XmlStringBuilder closeEmptyElement() {
        this.sb.append("/>");
        return this;
    }

    public XmlStringBuilder rightAngelBracket() {
        this.sb.append(RIGHT_ANGEL_BRACKET);
        return this;
    }

    public XmlStringBuilder attribute(String string, String string2) {
        assert (string2 != null);
        this.sb.append(' ').append(string).append("='");
        this.escape(string2);
        this.sb.append('\'');
        return this;
    }

    public XmlStringBuilder attribute(String string, Enum<?> enum_) {
        assert (enum_ != null);
        this.attribute(string, enum_.name());
        return this;
    }

    public XmlStringBuilder optAttribute(String string, String string2) {
        if (string2 != null) {
            this.attribute(string, string2);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String string, Enum<?> enum_) {
        if (enum_ != null) {
            this.attribute(string, enum_.name());
        }
        return this;
    }

    public XmlStringBuilder xmlnsAttribute(String string) {
        this.optAttribute("xmlns", string);
        return this;
    }

    public XmlStringBuilder xmllangAttribute(String string) {
        this.optAttribute("xml:lang", string);
        return this;
    }

    public XmlStringBuilder escape(String string) {
        assert (string != null);
        this.sb.append(StringUtils.escapeForXML(string));
        return this;
    }

    public XmlStringBuilder prelude(PacketExtension packetExtension) {
        this.halfOpenElement(packetExtension.getElementName());
        this.xmlnsAttribute(packetExtension.getNamespace());
        return this;
    }

    public XmlStringBuilder optAppend(CharSequence charSequence) {
        if (charSequence != null) {
            this.append(charSequence);
        }
        return this;
    }

    public XmlStringBuilder append(XmlStringBuilder xmlStringBuilder) {
        assert (xmlStringBuilder != null);
        this.sb.append(xmlStringBuilder.sb);
        return this;
    }

    public XmlStringBuilder emptyElement(String string) {
        this.halfOpenElement(string);
        return this.closeEmptyElement();
    }

    public XmlStringBuilder condEmptyElement(boolean bl, String string) {
        if (bl) {
            this.emptyElement(string);
        }
        return this;
    }

    public XmlStringBuilder condAttribute(boolean bl, String string, String string2) {
        if (bl) {
            this.attribute(string, string2);
        }
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence charSequence) {
        assert (charSequence != null);
        this.sb.append(charSequence);
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence charSequence, int n, int n2) {
        assert (charSequence != null);
        this.sb.append(charSequence, n, n2);
        return this;
    }

    @Override
    public XmlStringBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int n) {
        return this.sb.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.sb.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XmlStringBuilder)) {
            return false;
        }
        XmlStringBuilder xmlStringBuilder = (XmlStringBuilder)object;
        return this.toString().equals(xmlStringBuilder.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

