/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

public class HostAddress {
    private final String fqdn;
    private final int port;
    private Exception exception;

    public HostAddress(String string) {
        this(string, 5222);
    }

    public HostAddress(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("FQDN is null");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port must be a 16-bit unsiged integer (i.e. between 0-65535. Port was: " + n);
        }
        this.fqdn = string.charAt(string.length() - 1) == '.' ? string.substring(0, string.length() - 1) : string;
        this.port = n;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public int getPort() {
        return this.port;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return this.fqdn + ":" + this.port;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HostAddress)) {
            return false;
        }
        HostAddress hostAddress = (HostAddress)object;
        if (!this.fqdn.equals(hostAddress.fqdn)) {
            return false;
        }
        return this.port == hostAddress.port;
    }

    public int hashCode() {
        int n = 1;
        n = 37 * n + this.fqdn.hashCode();
        return n * 37 + this.port;
    }

    public String getErrorMessage() {
        String string = this.exception == null ? "No error logged" : this.exception.getMessage();
        return this.toString() + " Exception: " + string;
    }
}

