/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import org.jivesoftware.smack.util.dns.HostAddress;

public class SRVRecord
extends HostAddress
implements Comparable<SRVRecord> {
    private int weight;
    private int priority;

    public SRVRecord(String string, int n, int n2, int n3) {
        super(string, n);
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("DNS SRV records weight must be a 16-bit unsiged integer (i.e. between 0-65535. Weight was: " + n3);
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("DNS SRV records priority must be a 16-bit unsiged integer (i.e. between 0-65535. Priority was: " + n2);
        }
        this.priority = n2;
        this.weight = n3;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(SRVRecord sRVRecord) {
        int n = sRVRecord.priority - this.priority;
        if (n == 0) {
            n = this.weight - sRVRecord.weight;
        }
        return n;
    }

    @Override
    public String toString() {
        return super.toString() + " prio:" + this.priority + ":w:" + this.weight;
    }
}

