/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;

public class MultipleRecipientManager {
    private static final Logger LOGGER = Logger.getLogger(MultipleRecipientManager.class.getName());
    private static Cache<String, String> services = new Cache(100, 86400000L);

    public static void send(XMPPConnection xMPPConnection, Packet packet, List<String> list, List<String> list2, List<String> list3) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        MultipleRecipientManager.send(xMPPConnection, packet, list, list2, list3, null, null, false);
    }

    public static void send(XMPPConnection xMPPConnection, Packet packet, List<String> list, List<String> list2, List<String> list3, String string, String string2, boolean bl) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        String string3 = MultipleRecipientManager.getMultipleRecipienServiceAddress(xMPPConnection);
        if (string3 != null) {
            MultipleRecipientManager.sendThroughService(xMPPConnection, packet, list, list2, list3, string, string2, bl, string3);
        } else {
            if (bl || string != null && string.trim().length() > 0 || string2 != null && string2.trim().length() > 0) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(xMPPConnection, packet, list, list2, list3);
        }
    }

    public static void reply(XMPPConnection xMPPConnection, Message message, Message message2) throws SmackException, XMPPException.XMPPErrorException {
        MultipleAddresses.Address address;
        MultipleRecipientInfo multipleRecipientInfo = MultipleRecipientManager.getMultipleRecipientInfo(message);
        if (multipleRecipientInfo == null) {
            throw new SmackException("Original message does not contain multiple recipient info");
        }
        if (multipleRecipientInfo.shouldNotReply()) {
            throw new SmackException("Original message should not be replied");
        }
        if (multipleRecipientInfo.getReplyRoom() != null) {
            throw new SmackException("Reply should be sent through a room");
        }
        if (message.getThread() != null) {
            message2.setThread(message.getThread());
        }
        if ((address = multipleRecipientInfo.getReplyAddress()) != null && address.getJid() != null) {
            message2.setTo(address.getJid());
            xMPPConnection.sendPacket(message2);
        } else {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Object object = multipleRecipientInfo.getTOAddresses().iterator();
            while (object.hasNext()) {
                string = object.next().getJid();
                arrayList.add(string);
            }
            object = multipleRecipientInfo.getCCAddresses().iterator();
            while (object.hasNext()) {
                string = object.next().getJid();
                arrayList2.add(string);
            }
            if (!arrayList.contains(message.getFrom()) && !arrayList2.contains(message.getFrom())) {
                arrayList.add(message.getFrom());
            }
            if (!arrayList.remove(object = xMPPConnection.getUser()) && !arrayList2.remove(object)) {
                string = StringUtils.parseBareAddress((String)object);
                arrayList.remove(string);
                arrayList2.remove(string);
            }
            if ((string = MultipleRecipientManager.getMultipleRecipienServiceAddress(xMPPConnection)) != null) {
                MultipleRecipientManager.sendThroughService(xMPPConnection, message2, arrayList, arrayList2, null, null, null, false, string);
            } else {
                MultipleRecipientManager.sendToIndividualRecipients(xMPPConnection, message2, arrayList, arrayList2, null);
            }
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Packet packet) {
        MultipleAddresses multipleAddresses = (MultipleAddresses)packet.getExtension("addresses", "http://jabber.org/protocol/address");
        return multipleAddresses == null ? null : new MultipleRecipientInfo(multipleAddresses);
    }

    private static void sendToIndividualRecipients(XMPPConnection xMPPConnection, Packet packet, List<String> list, List<String> list2, List<String> list3) throws SmackException.NotConnectedException {
        if (list != null) {
            for (String string : list) {
                packet.setTo(string);
                xMPPConnection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
        if (list2 != null) {
            for (String string : list2) {
                packet.setTo(string);
                xMPPConnection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
        if (list3 != null) {
            for (String string : list3) {
                packet.setTo(string);
                xMPPConnection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
    }

    private static void sendThroughService(XMPPConnection xMPPConnection, Packet packet, List<String> list, List<String> list2, List<String> list3, String string, String string2, boolean bl, String string3) throws SmackException.NotConnectedException {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (list != null) {
            for (String string4 : list) {
                multipleAddresses.addAddress("to", string4, null, null, false, null);
            }
        }
        if (list2 != null) {
            for (String string4 : list2) {
                multipleAddresses.addAddress("cc", string4, null, null, false, null);
            }
        }
        if (list3 != null) {
            for (String string4 : list3) {
                multipleAddresses.addAddress("bcc", string4, null, null, false, null);
            }
        }
        if (bl) {
            multipleAddresses.setNoReply();
        } else {
            if (string != null && string.trim().length() > 0) {
                multipleAddresses.addAddress("replyto", string, null, null, false, null);
            }
            if (string2 != null && string2.trim().length() > 0) {
                multipleAddresses.addAddress("replyroom", string2, null, null, false, null);
            }
        }
        packet.setTo(string3);
        packet.addExtension(multipleAddresses);
        xMPPConnection.sendPacket(packet);
    }

    private static String getMultipleRecipienServiceAddress(XMPPConnection xMPPConnection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        String string = xMPPConnection.getServiceName();
        String string2 = services.get(string);
        if (string2 == null) {
            ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
            DiscoverInfo discoverInfo = null;
            try {
                discoverInfo = serviceDiscoveryManager.discoverInfo(string);
            }
            catch (XMPPException.XMPPErrorException xMPPErrorException) {
                LOGGER.log(Level.WARNING, "Exception while discovering info of service", xMPPErrorException);
            }
            if (discoverInfo != null && discoverInfo.containsFeature("http://jabber.org/protocol/address")) {
                string2 = string;
            } else {
                try {
                    DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(string);
                    for (DiscoverItems.Item item : discoverItems.getItems()) {
                        try {
                            discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID(), item.getNode());
                        }
                        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException exception) {
                            LOGGER.log(Level.WARNING, "Exception while discovering info of " + item.getEntityID() + " node: " + item.getNode(), exception);
                            continue;
                        }
                        if (!discoverInfo.containsFeature("http://jabber.org/protocol/address")) continue;
                        string2 = string;
                        break;
                    }
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException) {
                    LOGGER.log(Level.WARNING, "Exception while disvering items of service", xMPPErrorException);
                }
            }
            string2 = string2 == null ? "" : string2;
            services.put(string, string2);
        }
        return "".equals(string2) ? null : string2;
    }

    private static class PacketCopy
    extends Packet {
        private CharSequence text;

        public PacketCopy(CharSequence charSequence) {
            this.text = charSequence;
        }

        @Override
        public CharSequence toXML() {
            return this.text;
        }
    }
}

