/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;

public class MultipleAddresses
implements PacketExtension {
    public static final String NAMESPACE = "http://jabber.org/protocol/address";
    public static final String ELEMENT = "addresses";
    public static final String BCC = "bcc";
    public static final String CC = "cc";
    public static final String NO_REPLY = "noreply";
    public static final String REPLY_ROOM = "replyroom";
    public static final String REPLY_TO = "replyto";
    public static final String TO = "to";
    private List<Address> addresses = new ArrayList<Address>();

    public void addAddress(String string, String string2, String string3, String string4, boolean bl, String string5) {
        Address address = new Address(string);
        address.setJid(string2);
        address.setNode(string3);
        address.setDescription(string4);
        address.setDelivered(bl);
        address.setUri(string5);
        this.addresses.add(address);
    }

    public void setNoReply() {
        Address address = new Address(NO_REPLY);
        this.addresses.add(address);
    }

    public List<Address> getAddressesOfType(String string) {
        ArrayList<Address> arrayList = new ArrayList<Address>(this.addresses.size());
        for (Address address : this.addresses) {
            if (!address.getType().equals(string)) continue;
            arrayList.add(address);
        }
        return arrayList;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName());
        stringBuilder.append(" xmlns=\"").append(NAMESPACE).append("\">");
        for (Address address : this.addresses) {
            stringBuilder.append(address.toXML());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public static class Address {
        private String type;
        private String jid;
        private String node;
        private String description;
        private boolean delivered;
        private String uri;

        private Address(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public String getJid() {
            return this.jid;
        }

        private void setJid(String string) {
            this.jid = string;
        }

        public String getNode() {
            return this.node;
        }

        private void setNode(String string) {
            this.node = string;
        }

        public String getDescription() {
            return this.description;
        }

        private void setDescription(String string) {
            this.description = string;
        }

        public boolean isDelivered() {
            return this.delivered;
        }

        private void setDelivered(boolean bl) {
            this.delivered = bl;
        }

        public String getUri() {
            return this.uri;
        }

        private void setUri(String string) {
            this.uri = string;
        }

        private String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<address type=\"");
            stringBuilder.append(this.type).append("\"");
            if (this.jid != null) {
                stringBuilder.append(" jid=\"");
                stringBuilder.append(this.jid).append("\"");
            }
            if (this.node != null) {
                stringBuilder.append(" node=\"");
                stringBuilder.append(this.node).append("\"");
            }
            if (this.description != null && this.description.trim().length() > 0) {
                stringBuilder.append(" desc=\"");
                stringBuilder.append(this.description).append("\"");
            }
            if (this.delivered) {
                stringBuilder.append(" delivered=\"true\"");
            }
            if (this.uri != null) {
                stringBuilder.append(" uri=\"");
                stringBuilder.append(this.uri).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

