/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;

public class AMPManager {
    public static synchronized void setServiceEnabled(XMPPConnection xMPPConnection, boolean bl) {
        if (AMPManager.isServiceEnabled(xMPPConnection) == bl) {
            return;
        }
        if (bl) {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature("http://jabber.org/protocol/amp");
        } else {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).removeFeature("http://jabber.org/protocol/amp");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection) {
        xMPPConnection.getServiceName();
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).includesFeature("http://jabber.org/protocol/amp");
    }

    public static boolean isActionSupported(XMPPConnection xMPPConnection, AMPExtension.Action action) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        String string = "http://jabber.org/protocol/amp?action=" + action.toString();
        return AMPManager.isFeatureSupportedByServer(xMPPConnection, string, "http://jabber.org/protocol/amp");
    }

    public static boolean isConditionSupported(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        String string2 = "http://jabber.org/protocol/amp?condition=" + string;
        return AMPManager.isFeatureSupportedByServer(xMPPConnection, string2, "http://jabber.org/protocol/amp");
    }

    private static boolean isFeatureSupportedByServer(XMPPConnection xMPPConnection, String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(xMPPConnection.getServiceName(), string2);
        for (DiscoverInfo.Feature feature : discoverInfo.getFeatures()) {
            if (!string.equals(feature.getVar())) continue;
            return true;
        }
        return false;
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                AMPManager.setServiceEnabled(xMPPConnection, true);
            }
        });
    }
}

