/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.Bookmarks;
import org.jivesoftware.smackx.iqprivate.PrivateDataManager;

public class BookmarkManager {
    private static final Map<XMPPConnection, BookmarkManager> bookmarkManagerMap = new WeakHashMap<XMPPConnection, BookmarkManager>();
    private PrivateDataManager privateDataManager;
    private Bookmarks bookmarks;
    private final Object bookmarkLock = new Object();

    public static synchronized BookmarkManager getBookmarkManager(XMPPConnection xMPPConnection) throws XMPPException, SmackException {
        BookmarkManager bookmarkManager = bookmarkManagerMap.get(xMPPConnection);
        if (bookmarkManager == null) {
            bookmarkManager = new BookmarkManager(xMPPConnection);
        }
        return bookmarkManager;
    }

    private BookmarkManager(XMPPConnection xMPPConnection) throws XMPPException, SmackException {
        this.privateDataManager = PrivateDataManager.getInstanceFor(xMPPConnection);
        bookmarkManagerMap.put(xMPPConnection, this);
    }

    public Collection<BookmarkedConference> getBookmarkedConferences() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        return Collections.unmodifiableCollection(this.bookmarks.getBookmarkedConferences());
    }

    public void addBookmarkedConference(String string, String string2, boolean bl, String string3, String string4) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        BookmarkedConference bookmarkedConference = new BookmarkedConference(string, string2, bl, string3, string4);
        List<BookmarkedConference> list = this.bookmarks.getBookmarkedConferences();
        if (list.contains(bookmarkedConference)) {
            BookmarkedConference bookmarkedConference2 = list.get(list.indexOf(bookmarkedConference));
            if (bookmarkedConference2.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmark");
            }
            bookmarkedConference2.setAutoJoin(bl);
            bookmarkedConference2.setName(string);
            bookmarkedConference2.setNickname(string3);
            bookmarkedConference2.setPassword(string4);
        } else {
            this.bookmarks.addBookmarkedConference(bookmarkedConference);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedConference(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        Iterator<BookmarkedConference> iterator = this.bookmarks.getBookmarkedConferences().iterator();
        while (iterator.hasNext()) {
            BookmarkedConference bookmarkedConference = iterator.next();
            if (!bookmarkedConference.getJid().equalsIgnoreCase(string)) continue;
            if (bookmarkedConference.isShared()) {
                throw new IllegalArgumentException("Conference is shared and can't be removed");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public Collection<BookmarkedURL> getBookmarkedURLs() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        return Collections.unmodifiableCollection(this.bookmarks.getBookmarkedURLS());
    }

    public void addBookmarkedURL(String string, String string2, boolean bl) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        BookmarkedURL bookmarkedURL = new BookmarkedURL(string, string2, bl);
        List<BookmarkedURL> list = this.bookmarks.getBookmarkedURLS();
        if (list.contains(bookmarkedURL)) {
            BookmarkedURL bookmarkedURL2 = list.get(list.indexOf(bookmarkedURL));
            if (bookmarkedURL2.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmarks");
            }
            bookmarkedURL2.setName(string2);
            bookmarkedURL2.setRss(bl);
        } else {
            this.bookmarks.addBookmarkedURL(bookmarkedURL);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedURL(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        Iterator<BookmarkedURL> iterator = this.bookmarks.getBookmarkedURLS().iterator();
        while (iterator.hasNext()) {
            BookmarkedURL bookmarkedURL = iterator.next();
            if (!bookmarkedURL.getURL().equalsIgnoreCase(string)) continue;
            if (bookmarkedURL.isShared()) {
                throw new IllegalArgumentException("Cannot delete a shared bookmark.");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bookmarks retrieveBookmarks() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Object object = this.bookmarkLock;
        synchronized (object) {
            if (this.bookmarks == null) {
                this.bookmarks = (Bookmarks)this.privateDataManager.getPrivateData("storage", "storage:bookmarks");
            }
            return this.bookmarks;
        }
    }

    static {
        PrivateDataManager.addPrivateDataProvider("storage", "storage:bookmarks", new Bookmarks.Provider());
    }
}

