/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.SharedBookmark;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Bookmarks
implements PrivateData {
    public static final String NAMESPACE = "storage:bookmarks";
    public static final String ELEMENT = "storage";
    private List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement(ELEMENT).xmlnsAttribute(NAMESPACE).rightAngelBracket();
        for (BookmarkedURL sharedBookmark : this.getBookmarkedURLS()) {
            if (sharedBookmark.isShared()) continue;
            xmlStringBuilder.halfOpenElement("url").attribute("name", sharedBookmark.getName()).attribute("url", sharedBookmark.getURL());
            xmlStringBuilder.condAttribute(sharedBookmark.isRss(), "rss", "true");
            xmlStringBuilder.closeEmptyElement();
        }
        for (BookmarkedConference bookmarkedConference : this.getBookmarkedConferences()) {
            if (bookmarkedConference.isShared()) continue;
            xmlStringBuilder.halfOpenElement("conference");
            xmlStringBuilder.attribute("name", bookmarkedConference.getName());
            xmlStringBuilder.attribute("autojoin", Boolean.toString(bookmarkedConference.isAutoJoin()));
            xmlStringBuilder.attribute("jid", bookmarkedConference.getJid());
            xmlStringBuilder.rightAngelBracket();
            xmlStringBuilder.optElement("nick", bookmarkedConference.getNickname());
            xmlStringBuilder.optElement("password", bookmarkedConference.getPassword());
            xmlStringBuilder.closeElement("conference");
        }
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    private static BookmarkedURL getURLStorage(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        String string = xmlPullParser.getAttributeValue("", "name");
        String string2 = xmlPullParser.getAttributeValue("", "url");
        String string3 = xmlPullParser.getAttributeValue("", "rss");
        boolean bl = string3 != null && "true".equals(string3);
        BookmarkedURL bookmarkedURL = new BookmarkedURL(string2, string, bl);
        boolean bl2 = false;
        while (!bl2) {
            int n = xmlPullParser.next();
            if (n == 2 && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedURL.setShared(true);
                continue;
            }
            if (n != 3 || !"url".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return bookmarkedURL;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue("", "name");
        String string2 = xmlPullParser.getAttributeValue("", "autojoin");
        String string3 = xmlPullParser.getAttributeValue("", "jid");
        BookmarkedConference bookmarkedConference = new BookmarkedConference(string3);
        bookmarkedConference.setName(string);
        bookmarkedConference.setAutoJoin(Boolean.valueOf(string2));
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2 && "nick".equals(xmlPullParser.getName())) {
                bookmarkedConference.setNickname(xmlPullParser.nextText());
                continue;
            }
            if (n == 2 && "password".equals(xmlPullParser.getName())) {
                bookmarkedConference.setPassword(xmlPullParser.nextText());
                continue;
            }
            if (n == 2 && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedConference.setShared(true);
                continue;
            }
            if (n != 3 || !"conference".equals(xmlPullParser.getName())) continue;
            bl = true;
        }
        return bookmarkedConference;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser xmlPullParser) throws Exception {
            Bookmarks bookmarks = new Bookmarks();
            boolean bl = false;
            while (!bl) {
                SharedBookmark sharedBookmark;
                int n = xmlPullParser.next();
                if (n == 2 && "url".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getURLStorage(xmlPullParser);
                    if (sharedBookmark == null) continue;
                    bookmarks.addBookmarkedURL((BookmarkedURL)sharedBookmark);
                    continue;
                }
                if (n == 2 && "conference".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getConferenceStorage(xmlPullParser);
                    bookmarks.addBookmarkedConference((BookmarkedConference)sharedBookmark);
                    continue;
                }
                if (n != 3 || !Bookmarks.ELEMENT.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return bookmarks;
        }
    }
}

