/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;

public class Open
extends IQ {
    private final String sessionID;
    private final int blockSize;
    private final InBandBytestreamManager.StanzaType stanza;

    public Open(String string, int n, InBandBytestreamManager.StanzaType stanzaType) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Block size must be greater than zero");
        }
        this.sessionID = string;
        this.blockSize = n;
        this.stanza = stanzaType;
        this.setType(IQ.Type.SET);
    }

    public Open(String string, int n) {
        this(string, n, InBandBytestreamManager.StanzaType.IQ);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public InBandBytestreamManager.StanzaType getStanza() {
        return this.stanza;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<open ");
        stringBuilder.append("xmlns=\"");
        stringBuilder.append("http://jabber.org/protocol/ibb");
        stringBuilder.append("\" ");
        stringBuilder.append("block-size=\"");
        stringBuilder.append(this.blockSize);
        stringBuilder.append("\" ");
        stringBuilder.append("sid=\"");
        stringBuilder.append(this.sessionID);
        stringBuilder.append("\" ");
        stringBuilder.append("stanza=\"");
        stringBuilder.append(this.stanza.toString().toLowerCase(Locale.US));
        stringBuilder.append("\"");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }
}

