/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

class Socks5ClientForInitiator
extends Socks5Client {
    private XMPPConnection connection;
    private String sessionID;
    private String target;

    public Socks5ClientForInitiator(Bytestream.StreamHost streamHost, String string, XMPPConnection xMPPConnection, String string2, String string3) {
        super(streamHost, string);
        this.connection = xMPPConnection;
        this.sessionID = string2;
        this.target = string3;
    }

    @Override
    public Socket getSocket(int n) throws IOException, InterruptedException, TimeoutException, XMPPException, SmackException {
        Socket socket = null;
        if (this.streamHost.getJID().equals(this.connection.getUser())) {
            Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
            socket = socks5Proxy.getSocket(this.digest);
            if (socket == null) {
                throw new SmackException("target is not connected to SOCKS5 proxy");
            }
        } else {
            socket = super.getSocket(n);
            try {
                this.activate();
            }
            catch (XMPPException xMPPException) {
                socket.close();
                throw xMPPException;
            }
            catch (SmackException.NoResponseException noResponseException) {
                socket.close();
                throw noResponseException;
            }
        }
        return socket;
    }

    private void activate() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Bytestream bytestream = this.createStreamHostActivation();
        this.connection.createPacketCollectorAndSend(bytestream).nextResultOrThrow();
    }

    private Bytestream createStreamHostActivation() {
        Bytestream bytestream = new Bytestream(this.sessionID);
        bytestream.setMode(null);
        bytestream.setType(IQ.Type.SET);
        bytestream.setTo(this.streamHost.getJID());
        bytestream.setToActivate(this.target);
        return bytestream;
    }
}

