/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.forward.Forwarded;

public class CarbonExtension
implements PacketExtension {
    public static final String NAMESPACE = "urn:xmpp:carbons:2";
    private Direction dir;
    private Forwarded fwd;

    public CarbonExtension(Direction direction, Forwarded forwarded) {
        this.dir = direction;
        this.fwd = forwarded;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public Forwarded getForwarded() {
        return this.fwd;
    }

    @Override
    public String getElementName() {
        return this.dir.toString();
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        stringBuilder.append(this.fwd.toXML());
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public static class Private
    implements PacketExtension {
        public static final String ELEMENT = "private";

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return CarbonExtension.NAMESPACE;
        }

        @Override
        public String toXML() {
            return "<private xmlns=\"urn:xmpp:carbons:2\"/>";
        }
    }

    public static enum Direction {
        received,
        sent;

    }
}

