/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateListener;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class ChatStateManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/chatstates";
    private static final Map<XMPPConnection, ChatStateManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatStateManager>();
    private static final PacketFilter filter = new NotFilter(new PacketExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final OutgoingMessageInterceptor outgoingInterceptor = new OutgoingMessageInterceptor();
    private final IncomingMessageInterceptor incomingInterceptor = new IncomingMessageInterceptor();
    private final Map<Chat, ChatState> chatStates = new WeakHashMap<Chat, ChatState>();
    private final ChatManager chatManager;

    public static synchronized ChatStateManager getInstance(XMPPConnection xMPPConnection) {
        ChatStateManager chatStateManager = INSTANCES.get(xMPPConnection);
        if (chatStateManager == null) {
            chatStateManager = new ChatStateManager(xMPPConnection);
        }
        return chatStateManager;
    }

    private ChatStateManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.chatManager = ChatManager.getInstanceFor(xMPPConnection);
        this.chatManager.addOutgoingMessageInterceptor(this.outgoingInterceptor, filter);
        this.chatManager.addChatListener(this.incomingInterceptor);
        ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature(NAMESPACE);
        INSTANCES.put(xMPPConnection, this);
    }

    public void setCurrentState(ChatState chatState, Chat chat) throws SmackException.NotConnectedException {
        if (chat == null || chatState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, chatState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension chatStateExtension = new ChatStateExtension(chatState);
        message.addExtension(chatStateExtension);
        chat.sendMessage(message);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChatStateManager chatStateManager = (ChatStateManager)object;
        return this.connection().equals(chatStateManager.connection());
    }

    public int hashCode() {
        return this.connection().hashCode();
    }

    private synchronized boolean updateChatState(Chat chat, ChatState chatState) {
        ChatState chatState2 = this.chatStates.get(chat);
        if (chatState2 != chatState) {
            this.chatStates.put(chat, chatState);
            return true;
        }
        return false;
    }

    private void fireNewChatState(Chat chat, ChatState chatState) {
        for (MessageListener messageListener : chat.getListeners()) {
            if (!(messageListener instanceof ChatStateListener)) continue;
            ((ChatStateListener)messageListener).stateChanged(chat, chatState);
        }
    }

    private class IncomingMessageInterceptor
    implements ChatManagerListener,
    MessageListener {
        private IncomingMessageInterceptor() {
        }

        @Override
        public void chatCreated(Chat chat, boolean bl) {
            chat.addMessageListener(this);
        }

        @Override
        public void processMessage(Chat chat, Message message) {
            ChatState chatState;
            PacketExtension packetExtension = message.getExtension(ChatStateManager.NAMESPACE);
            if (packetExtension == null) {
                return;
            }
            try {
                chatState = ChatState.valueOf(packetExtension.getElementName());
            }
            catch (Exception exception) {
                return;
            }
            ChatStateManager.this.fireNewChatState(chat, chatState);
        }
    }

    private class OutgoingMessageInterceptor
    implements PacketInterceptor {
        private OutgoingMessageInterceptor() {
        }

        @Override
        public void interceptPacket(Packet packet) {
            Message message = (Message)packet;
            Chat chat = ChatStateManager.this.chatManager.getThreadChat(message.getThread());
            if (chat == null) {
                return;
            }
            if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                message.addExtension(new ChatStateExtension(ChatState.active));
            }
        }
    }
}

