/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.xmlpull.v1.XmlPullParser;

public class ChatStateExtension
implements PacketExtension {
    private ChatState state;

    public ChatStateExtension(ChatState chatState) {
        this.state = chatState;
    }

    @Override
    public String getElementName() {
        return this.state.name();
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/chatstates";
    }

    @Override
    public String toXML() {
        return "<" + this.getElementName() + " xmlns=\"" + this.getNamespace() + "\" />";
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            ChatState chatState;
            try {
                chatState = ChatState.valueOf(xmlPullParser.getName());
            }
            catch (Exception exception) {
                chatState = ChatState.active;
            }
            return new ChatStateExtension(chatState);
        }
    }
}

