/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.xdata.Form;

public abstract class AdHocCommand {
    private AdHocCommandData data = new AdHocCommandData();

    public static SpecificErrorCondition getSpecificErrorCondition(XMPPError xMPPError) {
        for (SpecificErrorCondition specificErrorCondition : SpecificErrorCondition.values()) {
            if (xMPPError.getExtension(specificErrorCondition.toString(), "http://jabber.org/protocol/commands") == null) continue;
            return specificErrorCondition;
        }
        return null;
    }

    public void setName(String string) {
        this.data.setName(string);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setNode(String string) {
        this.data.setNode(string);
    }

    public String getNode() {
        return this.data.getNode();
    }

    public abstract String getOwnerJID();

    public List<AdHocCommandNote> getNotes() {
        return this.data.getNotes();
    }

    protected void addNote(AdHocCommandNote adHocCommandNote) {
        this.data.addNote(adHocCommandNote);
    }

    public String getRaw() {
        return this.data.getChildElementXML();
    }

    public Form getForm() {
        if (this.data.getForm() == null) {
            return null;
        }
        return new Form(this.data.getForm());
    }

    protected void setForm(Form form) {
        this.data.setForm(form.getDataFormToSend());
    }

    public abstract void execute() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException;

    public abstract void next(Form var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException;

    public abstract void complete(Form var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException;

    public abstract void prev() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException;

    public abstract void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException;

    protected List<Action> getActions() {
        return this.data.getActions();
    }

    protected void addActionAvailable(Action action) {
        this.data.addAction(action);
    }

    protected Action getExecuteAction() {
        return this.data.getExecuteAction();
    }

    protected void setExecuteAction(Action action) {
        this.data.setExecuteAction(action);
    }

    public Status getStatus() {
        return this.data.getStatus();
    }

    void setData(AdHocCommandData adHocCommandData) {
        this.data = adHocCommandData;
    }

    AdHocCommandData getData() {
        return this.data;
    }

    protected boolean isValidAction(Action action) {
        return this.getActions().contains((Object)action) || Action.cancel.equals((Object)action);
    }

    public static enum SpecificErrorCondition {
        badAction("bad-action"),
        malformedAction("malformed-action"),
        badLocale("bad-locale"),
        badPayload("bad-payload"),
        badSessionid("bad-sessionid"),
        sessionExpired("session-expired");

        private String value;

        private SpecificErrorCondition(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete,
        unknown;

    }

    public static enum Status {
        executing,
        completed,
        canceled;

    }
}

