/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ServiceDiscoveryManager
extends Manager {
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private EntityCapsManager capsManager;
    private static Map<XMPPConnection, ServiceDiscoveryManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        instances.put(xMPPConnection, this);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(DiscoverItems.class);
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                XMPPConnection xMPPConnection = ServiceDiscoveryManager.this.connection();
                if (xMPPConnection == null) {
                    return;
                }
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems discoverItems2 = new DiscoverItems();
                    discoverItems2.setType(IQ.Type.RESULT);
                    discoverItems2.setTo(discoverItems.getFrom());
                    discoverItems2.setPacketID(discoverItems.getPacketID());
                    discoverItems2.setNode(discoverItems.getNode());
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                    if (nodeInformationProvider != null) {
                        discoverItems2.addItems(nodeInformationProvider.getNodeItems());
                        discoverItems2.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else if (discoverItems.getNode() != null) {
                        discoverItems2.setType(IQ.Type.ERROR);
                        discoverItems2.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                    xMPPConnection.sendPacket(discoverItems2);
                }
            }
        };
        xMPPConnection.addPacketListener(packetListener, packetTypeFilter);
        packetTypeFilter = new PacketTypeFilter(DiscoverInfo.class);
        packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                XMPPConnection xMPPConnection = ServiceDiscoveryManager.this.connection();
                if (xMPPConnection == null) {
                    return;
                }
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo discoverInfo2 = new DiscoverInfo();
                    discoverInfo2.setType(IQ.Type.RESULT);
                    discoverInfo2.setTo(discoverInfo.getFrom());
                    discoverInfo2.setPacketID(discoverInfo.getPacketID());
                    discoverInfo2.setNode(discoverInfo.getNode());
                    if (discoverInfo.getNode() == null) {
                        ServiceDiscoveryManager.this.addDiscoverInfoTo(discoverInfo2);
                    } else {
                        NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                        if (nodeInformationProvider != null) {
                            discoverInfo2.addFeatures(nodeInformationProvider.getNodeFeatures());
                            discoverInfo2.addIdentities(nodeInformationProvider.getNodeIdentities());
                            discoverInfo2.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                        } else {
                            discoverInfo2.setType(IQ.Type.ERROR);
                            discoverInfo2.setError(new XMPPError(XMPPError.Condition.item_not_found));
                        }
                    }
                    xMPPConnection.sendPacket(discoverInfo2);
                }
            }
        };
        xMPPConnection.addPacketListener(packetListener, packetTypeFilter);
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public void setIdentityName(String string) {
        this.identity.setName(string);
        this.renewEntityCapsVersion();
    }

    public void setIdentity(DiscoverInfo.Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity can not be null");
        }
        this.identity = identity;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> hashSet = new HashSet<DiscoverInfo.Identity>(this.identities);
        hashSet.add(defaultIdentity);
        return Collections.unmodifiableSet(hashSet);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = instances.get(xMPPConnection);
        if (serviceDiscoveryManager == null) {
            serviceDiscoveryManager = new ServiceDiscoveryManager(xMPPConnection);
        }
        return serviceDiscoveryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoverInfoTo(DiscoverInfo discoverInfo) {
        discoverInfo.addIdentities(this.getIdentities());
        Set<String> set = this.features;
        synchronized (set) {
            for (String string : this.getFeatures()) {
                discoverInfo.addFeature(string);
            }
            discoverInfo.addExtension(this.extendedInfo);
        }
    }

    private NodeInformationProvider getNodeInformationProvider(String string) {
        if (string == null) {
            return null;
        }
        return this.nodeInformationProviders.get(string);
    }

    public void setNodeInformationProvider(String string, NodeInformationProvider nodeInformationProvider) {
        this.nodeInformationProviders.put(string, nodeInformationProvider);
    }

    public void removeNodeInformationProvider(String string) {
        this.nodeInformationProviders.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeatures() {
        Set<String> set = this.features;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeaturesList() {
        Set<String> set = this.features;
        synchronized (set) {
            return new LinkedList<String>(this.features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String string) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.add(string);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String string) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.remove(string);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String string) {
        Set<String> set = this.features;
        synchronized (set) {
            return this.features.contains(string);
        }
    }

    public void setExtendedInfo(DataForm dataForm) {
        this.extendedInfo = dataForm;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<PacketExtension> getExtendedInfoAsList() {
        ArrayList<DataForm> arrayList = null;
        if (this.extendedInfo != null) {
            arrayList = new ArrayList<DataForm>(1);
            arrayList.add(this.extendedInfo);
        }
        return arrayList;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (string == null) {
            return this.discoverInfo(null, null);
        }
        DiscoverInfo discoverInfo = EntityCapsManager.getDiscoverInfoByUser(string);
        if (discoverInfo != null) {
            return discoverInfo;
        }
        EntityCapsManager.NodeVerHash nodeVerHash = EntityCapsManager.getNodeVerHashByJid(string);
        discoverInfo = this.discoverInfo(string, nodeVerHash != null ? nodeVerHash.getNodeVer() : null);
        if (nodeVerHash != null && EntityCapsManager.verifyDiscoverInfoVersion(nodeVerHash.getVer(), nodeVerHash.getHash(), discoverInfo)) {
            EntityCapsManager.addDiscoverInfoByNode(nodeVerHash.getNodeVer(), discoverInfo);
        }
        return discoverInfo;
    }

    public DiscoverInfo discoverInfo(String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.GET);
        discoverInfo.setTo(string);
        discoverInfo.setNode(string2);
        Packet packet = this.connection().createPacketCollectorAndSend(discoverInfo).nextResultOrThrow();
        return (DiscoverInfo)packet;
    }

    public DiscoverItems discoverItems(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.discoverItems(string, null);
    }

    public DiscoverItems discoverItems(String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setType(IQ.Type.GET);
        discoverItems.setTo(string);
        discoverItems.setNode(string2);
        Packet packet = this.connection().createPacketCollectorAndSend(discoverItems).nextResultOrThrow();
        return (DiscoverItems)packet;
    }

    public boolean canPublishItems(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo discoverInfo = this.discoverInfo(string);
        return ServiceDiscoveryManager.canPublishItems(discoverInfo);
    }

    public static boolean canPublishItems(DiscoverInfo discoverInfo) {
        return discoverInfo.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String string, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.publishItems(string, null, discoverItems);
    }

    public void publishItems(String string, String string2, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(string);
        discoverItems.setNode(string2);
        this.connection().createPacketCollectorAndSend(discoverItems).nextResultOrThrow();
    }

    public boolean supportsFeature(String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo discoverInfo = this.discoverInfo(string);
        return discoverInfo.containsFeature(string2);
    }

    public void setEntityCapsManager(EntityCapsManager entityCapsManager) {
        this.capsManager = entityCapsManager;
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null && this.capsManager.entityCapsEnabled()) {
            this.capsManager.updateLocalEntityCaps();
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

