/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DiscoverInfo
extends IQ
implements Cloneable {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new LinkedList<Feature>();
    private final List<Identity> identities = new LinkedList<Identity>();
    private String node;

    public DiscoverInfo() {
    }

    public DiscoverInfo(DiscoverInfo discoverInfo) {
        super(discoverInfo);
        this.setNode(discoverInfo.getNode());
        for (Feature cloneable : discoverInfo.features) {
            this.addFeature(cloneable.clone());
        }
        for (Identity identity : discoverInfo.identities) {
            this.addIdentity(identity.clone());
        }
    }

    public void addFeature(String string) {
        this.addFeature(new Feature(string));
    }

    public void addFeatures(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            this.addFeature(string);
        }
    }

    private void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public void addIdentity(Identity identity) {
        this.identities.add(identity);
    }

    public void addIdentities(Collection<Identity> collection) {
        if (collection == null) {
            return;
        }
        this.identities.addAll(collection);
    }

    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public boolean containsFeature(String string) {
        for (Feature feature : this.getFeatures()) {
            if (!string.equals(feature.getVar())) continue;
            return true;
        }
        return false;
    }

    @Override
    public CharSequence getChildElementXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement("query");
        xmlStringBuilder.xmlnsAttribute(NAMESPACE);
        xmlStringBuilder.optAttribute("node", this.getNode());
        xmlStringBuilder.rightAngelBracket();
        for (Identity cloneable : this.identities) {
            xmlStringBuilder.append(cloneable.toXML());
        }
        for (Feature feature : this.features) {
            xmlStringBuilder.append(feature.toXML());
        }
        xmlStringBuilder.append(this.getExtensionsXML());
        xmlStringBuilder.closeElement("query");
        return xmlStringBuilder;
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> linkedList = new LinkedList<Identity>();
        for (Identity identity : this.identities) {
            for (Identity identity2 : linkedList) {
                if (!identity.equals(identity2)) continue;
                return true;
            }
            linkedList.add(identity);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        for (Feature feature : this.features) {
            for (Feature feature2 : linkedList) {
                if (!feature.equals(feature2)) continue;
                return true;
            }
            linkedList.add(feature);
        }
        return false;
    }

    public DiscoverInfo clone() {
        return new DiscoverInfo(this);
    }

    public static class Feature
    implements Cloneable {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(String string) {
            if (string == null) {
                throw new IllegalArgumentException("variable cannot be null");
            }
            this.variable = string;
        }

        public String getVar() {
            return this.variable;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("feature");
            xmlStringBuilder.attribute("var", this.variable);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Feature feature = (Feature)object;
            return this.variable.equals(feature.variable);
        }

        public int hashCode() {
            return 37 * this.variable.hashCode();
        }

        public Feature clone() {
            return new Feature(this);
        }
    }

    public static class Identity
    implements Comparable<Identity>,
    Cloneable {
        private final String category;
        private String name;
        private final String type;
        private String lang;

        public Identity(Identity identity) {
            this(identity.category, identity.name, identity.type);
            this.lang = identity.lang;
        }

        public Identity(String string, String string2, String string3) {
            if (string == null || string3 == null) {
                throw new IllegalArgumentException("category and type cannot be null");
            }
            this.category = string;
            this.name = string2;
            this.type = string3;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getType() {
            return this.type;
        }

        public void setLanguage(String string) {
            this.lang = string;
        }

        public String getLanguage() {
            return this.lang;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("identity");
            xmlStringBuilder.xmllangAttribute(this.lang);
            xmlStringBuilder.attribute("category", this.category);
            xmlStringBuilder.optAttribute("name", this.name);
            xmlStringBuilder.optAttribute("type", this.type);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public boolean equals(Object object) {
            String string;
            String string2;
            String string3;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Identity identity = (Identity)object;
            if (!this.category.equals(identity.category)) {
                return false;
            }
            String string4 = identity.lang == null ? "" : identity.lang;
            String string5 = string3 = this.lang == null ? "" : this.lang;
            if (!string4.equals(string3)) {
                return false;
            }
            String string6 = identity.type == null ? "" : identity.type;
            String string7 = string2 = this.type == null ? "" : this.type;
            if (!string6.equals(string2)) {
                return false;
            }
            String string8 = identity.name == null ? "" : identity.name;
            String string9 = string = this.name == null ? "" : identity.name;
            return string.equals(string8);
        }

        public int hashCode() {
            int n = 1;
            n = 37 * n + this.category.hashCode();
            n = 37 * n + (this.lang == null ? 0 : this.lang.hashCode());
            n = 37 * n + (this.type == null ? 0 : this.type.hashCode());
            n = 37 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        @Override
        public int compareTo(Identity identity) {
            String string;
            String string2 = identity.lang == null ? "" : identity.lang;
            String string3 = this.lang == null ? "" : this.lang;
            String string4 = identity.type == null ? "" : identity.type;
            String string5 = string = this.type == null ? "" : this.type;
            if (this.category.equals(identity.category)) {
                if (string.equals(string4)) {
                    if (string3.equals(string2)) {
                        return 0;
                    }
                    return string3.compareTo(string2);
                }
                return string.compareTo(string4);
            }
            return this.category.compareTo(identity.category);
        }

        public Identity clone() {
            return new Identity(this);
        }
    }
}

