/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;

public abstract class FileTransfer {
    private String fileName;
    private String filePath;
    private long fileSize;
    private String peer;
    private Status status = Status.initial;
    private final Object statusMonitor = new Object();
    protected FileTransferNegotiator negotiator;
    protected String streamID;
    protected long amountWritten = -1L;
    private Error error;
    private Exception exception;
    private static final int BUFFER_SIZE = 8192;

    protected FileTransfer(String string, String string2, FileTransferNegotiator fileTransferNegotiator) {
        this.peer = string;
        this.streamID = string2;
        this.negotiator = fileTransferNegotiator;
    }

    protected void setFileInfo(String string, long l) {
        this.fileName = string;
        this.fileSize = l;
    }

    protected void setFileInfo(String string, String string2, long l) {
        this.filePath = string;
        this.fileName = string2;
        this.fileSize = l;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPeer() {
        return this.peer;
    }

    public double getProgress() {
        if (this.amountWritten <= 0L || this.fileSize <= 0L) {
            return 0.0;
        }
        return (double)this.amountWritten / (double)this.fileSize;
    }

    public boolean isDone() {
        return this.status == Status.cancelled || this.status == Status.error || this.status == Status.complete || this.status == Status.refused;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setError(Error error) {
        this.error = error;
    }

    public Error getError() {
        return this.error;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getStreamID() {
        return this.streamID;
    }

    public abstract void cancel();

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(Status status) {
        Object object = this.statusMonitor;
        synchronized (object) {
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateStatus(Status status, Status status2) {
        Object object = this.statusMonitor;
        synchronized (object) {
            if (status != this.status) {
                return false;
            }
            this.status = status2;
            return true;
        }
    }

    protected void writeToStream(InputStream inputStream, OutputStream outputStream) throws SmackException {
        byte[] byArray = new byte[8192];
        int n = 0;
        this.amountWritten = 0L;
        do {
            try {
                outputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                throw new SmackException("error writing to output stream", iOException);
            }
            this.amountWritten += (long)n;
            try {
                n = inputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new SmackException("error reading from input stream", iOException);
            }
        } while (n != -1 && !this.getStatus().equals((Object)Status.cancelled));
        if (!this.getStatus().equals((Object)Status.cancelled) && this.getError() == Error.none && this.amountWritten != this.fileSize) {
            this.setStatus(Status.error);
            this.error = Error.connection;
        }
    }

    public long getAmountWritten() {
        return this.amountWritten;
    }

    public static enum Error {
        none("No error"),
        not_acceptable("The peer did not find any of the provided stream mechanisms acceptable."),
        bad_file("The provided file to transfer does not exist or could not be read."),
        no_response("The remote user did not respond or the connection timed out."),
        connection("An error occured over the socket connected to send the file."),
        stream("An error occured while sending or recieving the file.");

        private final String msg;

        private Error(String string2) {
            this.msg = string2;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return this.msg;
        }
    }

    public static enum Status {
        error("Error"),
        initial("Initial"),
        negotiating_transfer("Negotiating Transfer"),
        refused("Refused"),
        negotiating_stream("Negotiating Stream"),
        negotiated("Negotiated"),
        in_progress("In Progress"),
        complete("Complete"),
        cancelled("Cancelled");

        private String status;

        private Status(String string2) {
            this.status = string2;
        }

        public String toString() {
            return this.status;
        }
    }
}

