/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.provider;

import java.util.HashSet;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.shim.provider.HeaderProvider;
import org.xmlpull.v1.XmlPullParser;

public abstract class AbstractHttpOverXmppProvider
implements IQProvider {
    private static final String ELEMENT_HEADERS = "headers";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_DATA = "data";
    private static final String ELEMENT_TEXT = "text";
    private static final String ELEMENT_BASE_64 = "base64";
    private static final String ELEMENT_CHUNKED_BASE_64 = "chunkedBase64";
    private static final String ELEMENT_XML = "xml";
    static final String ELEMENT_IBB = "ibb";
    static final String ELEMENT_SIPUB = "sipub";
    static final String ELEMENT_JINGLE = "jingle";
    private static final String ATTRIBUTE_STREAM_ID = "streamId";
    private static final String ATTRIBUTE_SID = "sid";
    static final String ATTRIBUTE_VERSION = "version";

    protected void parseHeadersAndData(XmlPullParser xmlPullParser, String string, AbstractHttpOverXmpp.AbstractBody abstractBody) throws Exception {
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                Object object;
                if (xmlPullParser.getName().equals(ELEMENT_HEADERS)) {
                    object = this.parseHeaders(xmlPullParser);
                    abstractBody.setHeaders((HeadersExtension)object);
                    continue;
                }
                if (xmlPullParser.getName().endsWith(ELEMENT_DATA)) {
                    object = this.parseData(xmlPullParser);
                    abstractBody.setData((AbstractHttpOverXmpp.Data)object);
                    continue;
                }
                throw new IllegalArgumentException("unexpected tag:" + xmlPullParser.getName() + "'");
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
    }

    private HeadersExtension parseHeaders(XmlPullParser xmlPullParser) throws Exception {
        HeaderProvider headerProvider = new HeaderProvider();
        HashSet<Header> hashSet = new HashSet<Header>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals(ELEMENT_HEADER)) continue;
                Header header = (Header)headerProvider.parseExtension(xmlPullParser);
                hashSet.add(header);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(ELEMENT_HEADERS)) continue;
            bl = true;
        }
        return new HeadersExtension(hashSet);
    }

    private AbstractHttpOverXmpp.Data parseData(XmlPullParser xmlPullParser) throws Exception {
        AbstractHttpOverXmpp.DataChild dataChild = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals(ELEMENT_TEXT)) {
                    dataChild = this.parseText(xmlPullParser);
                    continue;
                }
                if (xmlPullParser.getName().equals(ELEMENT_BASE_64)) {
                    dataChild = this.parseBase64(xmlPullParser);
                    continue;
                }
                if (xmlPullParser.getName().equals(ELEMENT_CHUNKED_BASE_64)) {
                    dataChild = this.parseChunkedBase64(xmlPullParser);
                    continue;
                }
                if (xmlPullParser.getName().equals(ELEMENT_XML)) {
                    dataChild = this.parseXml(xmlPullParser);
                    continue;
                }
                if (xmlPullParser.getName().equals(ELEMENT_IBB)) {
                    dataChild = this.parseIbb(xmlPullParser);
                    continue;
                }
                if (xmlPullParser.getName().equals(ELEMENT_SIPUB)) {
                    throw new UnsupportedOperationException("sipub is not supported yet");
                }
                if (xmlPullParser.getName().equals(ELEMENT_JINGLE)) {
                    throw new UnsupportedOperationException("jingle is not supported yet");
                }
                throw new IllegalArgumentException("unsupported child tag: " + xmlPullParser.getName());
            }
            if (n != 3 || !xmlPullParser.getName().equals(ELEMENT_DATA)) continue;
            bl = true;
        }
        AbstractHttpOverXmpp.Data data = new AbstractHttpOverXmpp.Data(dataChild);
        return data;
    }

    private AbstractHttpOverXmpp.Text parseText(XmlPullParser xmlPullParser) throws Exception {
        String string = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 3) {
                if (xmlPullParser.getName().equals(ELEMENT_TEXT)) {
                    bl = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + xmlPullParser.getName());
            }
            if (n == 4) {
                string = xmlPullParser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + n);
        }
        return new AbstractHttpOverXmpp.Text(string);
    }

    private AbstractHttpOverXmpp.Xml parseXml(XmlPullParser xmlPullParser) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 3 && xmlPullParser.getName().equals(ELEMENT_XML)) {
                bl = true;
                continue;
            }
            if (n == 2) {
                if (!bl2) {
                    stringBuilder.append('>');
                }
                stringBuilder.append('<');
                stringBuilder.append(xmlPullParser.getName());
                this.appendXmlAttributes(xmlPullParser, stringBuilder);
                bl2 = false;
                continue;
            }
            if (n == 3) {
                if (bl2) {
                    stringBuilder.append("</");
                    stringBuilder.append(xmlPullParser.getName());
                    stringBuilder.append('>');
                    continue;
                }
                stringBuilder.append("/>");
                bl2 = true;
                continue;
            }
            if (n == 4) {
                if (!bl2) {
                    stringBuilder.append('>');
                    bl2 = true;
                }
                stringBuilder.append(StringUtils.escapeForXML(xmlPullParser.getText()));
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + n);
        }
        return new AbstractHttpOverXmpp.Xml(stringBuilder.toString());
    }

    private void appendXmlAttributes(XmlPullParser xmlPullParser, StringBuilder stringBuilder) throws Exception {
        int n = xmlPullParser.getAttributeCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append(xmlPullParser.getAttributeName(i));
                stringBuilder.append("=\"");
                stringBuilder.append(StringUtils.escapeForXML(xmlPullParser.getAttributeValue(i)));
                stringBuilder.append('\"');
            }
        }
    }

    private AbstractHttpOverXmpp.Base64 parseBase64(XmlPullParser xmlPullParser) throws Exception {
        String string = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 3) {
                if (xmlPullParser.getName().equals(ELEMENT_BASE_64)) {
                    bl = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag of: " + xmlPullParser.getName());
            }
            if (n == 4) {
                string = xmlPullParser.getText();
                continue;
            }
            throw new IllegalArgumentException("unexpected eventType: " + n);
        }
        return new AbstractHttpOverXmpp.Base64(string);
    }

    private AbstractHttpOverXmpp.ChunkedBase64 parseChunkedBase64(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue("", ATTRIBUTE_STREAM_ID);
        AbstractHttpOverXmpp.ChunkedBase64 chunkedBase64 = new AbstractHttpOverXmpp.ChunkedBase64(string);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 3) {
                if (xmlPullParser.getName().equals(ELEMENT_CHUNKED_BASE_64)) {
                    bl = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + xmlPullParser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + n);
        }
        return chunkedBase64;
    }

    private AbstractHttpOverXmpp.Ibb parseIbb(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue("", ATTRIBUTE_SID);
        AbstractHttpOverXmpp.Ibb ibb = new AbstractHttpOverXmpp.Ibb(string);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 3) {
                if (xmlPullParser.getName().equals(ELEMENT_IBB)) {
                    bl = true;
                    continue;
                }
                throw new IllegalArgumentException("unexpected end tag: " + xmlPullParser.getName());
            }
            throw new IllegalArgumentException("unexpected event type: " + n);
        }
        return ibb;
    }
}

